/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket.property;

import java.util.Iterator;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.wicket.property.Foo;
import org.geoserver.web.wicket.property.PropertyEditorTestPage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class PropertyEditorFormComponentTest
extends GeoServerWicketTestSupport {
    Foo foo;

    @Before
    public void init() {
        this.foo = new Foo();
    }

    void startPage() {
        tester.startPage((Page)new PropertyEditorTestPage(this.foo));
        tester.assertRenderedPage(PropertyEditorTestPage.class);
    }

    @Test
    @Ignore
    public void testAdd() {
        this.startPage();
        tester.clickLink("form:props:add", true);
        tester.assertComponent("form:props:container:list:0:key", TextField.class);
        tester.assertComponent("form:props:container:list:0:value", TextField.class);
        tester.assertComponent("form:props:container:list:0:remove", AjaxLink.class);
        FormTester form = tester.newFormTester("form");
        form.setValue("props:container:list:0:key", "foo");
        form.setValue("props:container:list:0:value", "bar");
        form.submit();
        Assert.assertEquals((long)1L, (long)this.foo.getProps().size());
        Assert.assertEquals((Object)"bar", (Object)this.foo.getProps().get("foo"));
    }

    @Test
    public void testRemove() {
        Component c;
        this.foo.getProps().put("foo", "bar");
        this.foo.getProps().put("bar", "baz");
        this.foo.getProps().put("baz", "foo");
        this.startPage();
        tester.assertComponent("form:props:container:list:0:remove", AjaxLink.class);
        tester.assertComponent("form:props:container:list:1:remove", AjaxLink.class);
        tester.assertComponent("form:props:container:list:2:remove", AjaxLink.class);
        try {
            tester.assertComponent("form:props:container:list:3:remove", AjaxLink.class);
            Assert.fail();
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
        ListView list = (ListView)tester.getComponentFromLastRenderedPage("form:props:container:list");
        Assert.assertNotNull((Object)list);
        int i = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext() && !"baz".equals((c = (Component)iterator.next()).get("key").getDefaultModelObjectAsString())) {
            ++i;
        }
        Assert.assertNotEquals((long)3L, (long)i);
        tester.clickLink("form:props:container:list:" + i + ":remove", true);
        tester.newFormTester("form").submit();
        Assert.assertEquals((long)2L, (long)this.foo.getProps().size());
        Assert.assertEquals((Object)"bar", (Object)this.foo.getProps().get("foo"));
        Assert.assertEquals((Object)"baz", (Object)this.foo.getProps().get("bar"));
        Assert.assertFalse((boolean)this.foo.getProps().containsKey("baz"));
    }

    @Test
    public void testAddRemove() {
        this.startPage();
        tester.clickLink("form:props:add", true);
        tester.assertComponent("form:props:container:list:0:key", TextField.class);
        tester.assertComponent("form:props:container:list:0:value", TextField.class);
        tester.assertComponent("form:props:container:list:0:remove", AjaxLink.class);
        FormTester form = tester.newFormTester("form");
        form.setValue("props:container:list:0:key", "foo");
        form.setValue("props:container:list:0:value", "bar");
        tester.clickLink("form:props:container:list:0:remove", true);
        Assert.assertNull((Object)form.getForm().get("props:container:list:0:key"));
        Assert.assertNull((Object)form.getForm().get("props:container:list:0:value"));
        Assert.assertNull((Object)form.getForm().get("props:container:list:0:remove"));
        form.submit();
        Assert.assertTrue((boolean)this.foo.getProps().isEmpty());
    }
}

