/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web;

import org.apache.wicket.Application;
import org.apache.wicket.core.request.mapper.CryptoMapper;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.IRequestMapper;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.mapper.IRequestMapperDelegate;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.web.GeoServerApplication;

class DynamicCryptoMapper
implements IRequestMapperDelegate {
    private IRequestMapper plainMapper;
    private CryptoMapper cryptoMapper;
    private GeoServerSecurityManager securityManager;

    public DynamicCryptoMapper(IRequestMapper plainMapper, GeoServerSecurityManager securityManager, GeoServerApplication application) {
        this.securityManager = securityManager;
        this.plainMapper = plainMapper;
        this.securityManager = securityManager;
        this.cryptoMapper = new CryptoMapper(plainMapper, (Application)application);
    }

    IRequestMapper getMapper() {
        if (this.securityManager.isEncryptingUrlParams()) {
            return this.cryptoMapper;
        }
        return this.plainMapper;
    }

    public IRequestHandler mapRequest(Request request) {
        return this.getMapper().mapRequest(request);
    }

    public int getCompatibilityScore(Request request) {
        return this.getMapper().getCompatibilityScore(request);
    }

    public Url mapHandler(IRequestHandler requestHandler) {
        return this.getMapper().mapHandler(requestHandler);
    }

    public IRequestMapper getDelegateMapper() {
        return this.getMapper();
    }
}

