/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.ExternalLink;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.geoserver.web.GeoServerBasePage;
import org.geotools.util.logging.Logging;

public class GeoServerErrorPage
extends GeoServerBasePage {
    static final Logger LOGGER = Logging.getLogger(GeoServerErrorPage.class);

    public GeoServerErrorPage(Throwable error) {
        LOGGER.log(Level.INFO, "Failure during page processing", error);
        ResourceModel notice = null;
        Model errorText = new Model((Serializable)((Object)""));
        boolean trace = false;
        if (this.getSession().getAuthentication() != null && this.getSession().getAuthentication().isAuthenticated()) {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                PrintStream ps = new PrintStream(bos);
                error.printStackTrace(ps);
                ps.close();
                bos.close();
                errorText = new Model((Serializable)((Object)bos.toString()));
                notice = new ResourceModel("GeoServerErrorPage.whatIsThis");
                trace = true;
            }
            catch (Exception e) {
                notice = new ResourceModel("GeoServerErrorPage.failedAgain");
            }
        }
        if (notice != null && notice.getObject() != null) {
            this.error((Serializable)((Object)notice.getObject().toString()));
        }
        this.add(new Component[]{new WebMarkupContainer("loggedOut").setVisible(!trace)});
        WebMarkupContainer wmc = new WebMarkupContainer("trace-explanation");
        wmc.setVisible(trace);
        wmc.add(new Component[]{new ExternalLink("userListLink", (IModel)new ResourceModel("userListLink"), (IModel)new ResourceModel("userListText")).setVisible(trace)});
        this.add(new Component[]{wmc});
        this.add(new Component[]{new Label("traceback", (IModel)errorText).setVisible(trace)});
    }
}

