/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.core.util.resource.locator.ResourceNameIterator;
import org.apache.wicket.markup.html.WebComponent;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.resource.IPropertiesFactory;
import org.apache.wicket.resource.Properties;
import org.apache.wicket.resource.loader.IStringResourceLoader;

public class GeoServerStringResourceLoader
implements IStringResourceLoader {
    public String loadStringResource(Class<?> clazz, String key, Locale locale, String style, String variation) {
        IPropertiesFactory propertiesFactory = Application.get().getResourceSettings().getPropertiesFactory();
        String path = "/GeoServerApplication";
        do {
            ResourceNameIterator iter = new ResourceNameIterator(path, style, variation, locale, null, false);
            while (iter.hasNext()) {
                String qualifiedKey;
                String value;
                String newPath = iter.next();
                Properties props = propertiesFactory.load(clazz, newPath);
                if (props == null || (value = props.getString(qualifiedKey = clazz != null ? clazz.getSimpleName() + "." + key : key)) == null) continue;
                return value;
            }
        } while (!this.isStopResourceSearch(clazz) && (clazz = clazz.getSuperclass()) != null);
        return null;
    }

    public String loadStringResource(Component component, String key, Locale locale, String style, String variation) {
        if (component == null) {
            return null;
        }
        String string = null;
        List containmentStack = this.getComponentStack(component);
        for (int i = containmentStack.size() - 1; i >= 0 && string == null; --i) {
            Class clazz = (Class)containmentStack.get(i);
            string = this.loadStringResource(clazz, key, locale, style, variation);
        }
        if (string == null) {
            string = this.loadStringResource((Class)null, key, locale, style, variation);
        }
        return string;
    }

    private List getComponentStack(Component component) {
        ArrayList searchStack = new ArrayList();
        searchStack.add(component.getClass());
        if (!(component instanceof Page)) {
            for (MarkupContainer container = component.getParent(); container != null; container = container.getParent()) {
                searchStack.add(container.getClass());
                if (container instanceof Page) break;
            }
        }
        return searchStack;
    }

    protected boolean isStopResourceSearch(Class<?> clazz) {
        if (clazz == null || clazz.equals(Object.class) || clazz.equals(Application.class)) {
            return true;
        }
        if (clazz.equals(WebPage.class) || clazz.equals(WebMarkupContainer.class) || clazz.equals(WebComponent.class)) {
            return true;
        }
        return clazz.equals(Page.class) || clazz.equals(MarkupContainer.class) || clazz.equals(Component.class);
    }
}

