/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.resource;

import java.math.BigDecimal;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.validation.validator.RangeValidator;

public class PeriodEditor
extends FormComponentPanel<BigDecimal> {
    static final long yearMS = 31536000000L;
    static final long monthMS = 2628000000L;
    static final long weekMS = 604800000L;
    static final long dayMS = 86400000L;
    static final long hourMS = 3600000L;
    static final long minuteMS = 60000L;
    static final long secondMS = 1000L;
    int years;
    int months;
    int weeks;
    int days;
    int hours;
    int minutes;
    int seconds;

    public PeriodEditor(String id, IModel<BigDecimal> model) {
        super(id, model);
        this.initComponents();
    }

    void initComponents() {
        this.updateFields();
        RangeValidator validator = new RangeValidator((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(Integer.MAX_VALUE));
        this.add(new Component[]{new TextField("years", (IModel)new PropertyModel((Object)this, "years")).add(new Behavior[]{validator})});
        this.add(new Component[]{new TextField("months", (IModel)new PropertyModel((Object)this, "months")).add(new Behavior[]{validator})});
        this.add(new Component[]{new TextField("weeks", (IModel)new PropertyModel((Object)this, "weeks")).add(new Behavior[]{validator})});
        this.add(new Component[]{new TextField("days", (IModel)new PropertyModel((Object)this, "days")).add(new Behavior[]{validator})});
        this.add(new Component[]{new TextField("hours", (IModel)new PropertyModel((Object)this, "hours")).add(new Behavior[]{validator})});
        this.add(new Component[]{new TextField("minutes", (IModel)new PropertyModel((Object)this, "minutes")).add(new Behavior[]{validator})});
        this.add(new Component[]{new TextField("seconds", (IModel)new PropertyModel((Object)this, "seconds")).add(new Behavior[]{validator})});
    }

    protected void onBeforeRender() {
        this.updateFields();
        super.onBeforeRender();
    }

    private void updateFields() {
        BigDecimal modelObject = (BigDecimal)this.getModelObject();
        long time = modelObject != null ? modelObject.longValue() : 0L;
        this.years = (int)(time / 31536000000L);
        this.months = (int)((time %= 31536000000L) / 2628000000L);
        this.weeks = (int)((time %= 2628000000L) / 604800000L);
        this.days = (int)((time %= 604800000L) / 86400000L);
        this.hours = (int)((time %= 86400000L) / 3600000L);
        this.minutes = (int)((time %= 3600000L) / 60000L);
        this.seconds = (int)((time %= 60000L) / 1000L);
    }

    public void convertInput() {
        this.visitChildren(TextField.class, (component, visit) -> ((TextField)component).processInput());
        long time = (long)this.seconds * 1000L + (long)this.minutes * 60000L + (long)this.hours * 3600000L + (long)this.days * 86400000L + (long)this.weeks * 604800000L + (long)this.months * 2628000000L + (long)this.years * 31536000000L;
        this.setConvertedInput(new BigDecimal(time));
    }

    protected void onModelChanged() {
        this.updateFields();
        this.visitChildren(TextField.class, (component, visit) -> ((TextField)component).clearInput());
    }
}

