/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.store;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.model.LoadableDetachableModel;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.web.GeoServerApplication;

public class StoreListModel
extends LoadableDetachableModel<List<StoreInfo>> {
    private static final long serialVersionUID = -7742496075623731474L;

    protected List<StoreInfo> load() {
        ArrayList<StoreInfo> stores = GeoServerApplication.get().getCatalog().getStores(StoreInfo.class);
        stores = new ArrayList<StoreInfo>(stores);
        Collections.sort(stores, (o1, o2) -> {
            if (o1.getWorkspace().equals(o2.getWorkspace())) {
                return o1.getName().compareTo(o2.getName());
            }
            return o1.getWorkspace().getName().compareTo(o2.getWorkspace().getName());
        });
        return stores;
    }
}

