/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.publish;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.ajax.markup.html.form.AjaxCheckBox;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.form.palette.Palette;
import org.apache.wicket.extensions.markup.html.form.palette.theme.DefaultTheme;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.ServiceResourceProvider;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.DisabledServiceResourceFilter;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.publish.PublishedConfigurationPanel;
import org.geoserver.web.wicket.GeoServerDialog;

public class ServiceLayerConfigurationPanel
extends PublishedConfigurationPanel<LayerInfo> {
    private static final long serialVersionUID = 1L;
    protected GeoServerDialog dialog;
    private WebMarkupContainer serviceSelectionContainer;
    private Palette<String> servicesMultiSelector;
    private Label defaultDisabledServicesLabel;
    private TextField<String> defaultDisabledServices;

    public ServiceLayerConfigurationPanel(String id, IModel<LayerInfo> layerModel) {
        super(id, layerModel);
        final String defaultDisabledServiceList = GeoServerExtensions.getProperty((String)DisabledServiceResourceFilter.PROPERTY);
        PropertyModel serviceConfigurationModel = new PropertyModel(layerModel, "resource.serviceConfiguration");
        AjaxCheckBox configEnabledCheck = new AjaxCheckBox("configEnabled", (IModel)serviceConfigurationModel){
            private static final long serialVersionUID = 1L;

            protected void onUpdate(AjaxRequestTarget target) {
                ServiceLayerConfigurationPanel.this.servicesMultiSelector.setVisible(((Boolean)this.getModelObject()).booleanValue());
                boolean showDefaults = StringUtils.isNotBlank((CharSequence)defaultDisabledServiceList) && this.getModelObject() != Boolean.TRUE;
                ServiceLayerConfigurationPanel.this.defaultDisabledServices.setVisible(showDefaults);
                ServiceLayerConfigurationPanel.this.defaultDisabledServicesLabel.setVisible(showDefaults);
                target.add(new Component[]{ServiceLayerConfigurationPanel.this});
            }
        };
        this.add(new Component[]{configEnabledCheck});
        PropertyModel dsModel = new PropertyModel(layerModel, "resource.disabledServices");
        ChoiceRenderer<String> renderer = new ChoiceRenderer<String>(){

            public String getObject(String id, IModel<? extends List<? extends String>> choices) {
                return id;
            }

            public Object getDisplayValue(String object) {
                if (object == null) {
                    return null;
                }
                return super.getDisplayValue((Object)object);
            }

            public String getIdValue(String object, int index) {
                return object;
            }
        };
        this.servicesMultiSelector = new Palette<String>("servicesSelection", (IModel)dsModel, this.servicesVotedModel(((LayerInfo)layerModel.getObject()).getResource()), (IChoiceRenderer)renderer, 10, false){
            private static final long serialVersionUID = 1L;

            public Component newSelectedHeader(String componentId) {
                return new Label(componentId, (IModel)new ResourceModel("DisabledServicesPalette.selectedHeader"));
            }

            public Component newAvailableHeader(String componentId) {
                return new Label(componentId, (IModel)new ResourceModel("DisabledServicesPalette.availableHeader"));
            }
        };
        this.servicesMultiSelector.add(new Behavior[]{new DefaultTheme()});
        this.servicesMultiSelector.setVisible(((LayerInfo)layerModel.getObject()).getResource().isServiceConfiguration());
        this.serviceSelectionContainer = new WebMarkupContainer("serviceSelectionContainer");
        this.serviceSelectionContainer.setOutputMarkupPlaceholderTag(true);
        this.add(new Component[]{this.serviceSelectionContainer});
        this.serviceSelectionContainer.add(new Component[]{this.servicesMultiSelector});
        boolean showDefaults = StringUtils.isNotBlank((CharSequence)defaultDisabledServiceList) && serviceConfigurationModel.getObject() != Boolean.TRUE;
        this.defaultDisabledServicesLabel = new Label("defaultDisabledServicesLabel", (IModel)new ResourceModel("DisabledServicesPalette.defaultDisabledServicesLabel"));
        this.defaultDisabledServicesLabel.setOutputMarkupId(true);
        this.defaultDisabledServicesLabel.setVisible(showDefaults);
        this.add(new Component[]{this.defaultDisabledServicesLabel});
        this.defaultDisabledServices = new TextField("defaultDisabledServices", (IModel)new Model((Serializable)((Object)(StringUtils.isBlank((CharSequence)defaultDisabledServiceList) ? "" : defaultDisabledServiceList))));
        this.defaultDisabledServices.setEnabled(false);
        this.defaultDisabledServices.setOutputMarkupId(true);
        this.defaultDisabledServices.setVisible(showDefaults);
        this.add(new Component[]{this.defaultDisabledServices});
        this.dialog = new GeoServerDialog("serviceDialog");
        this.add(new Component[]{this.dialog});
        this.add(new Component[]{new AjaxLink<String>("layerSettingsHelp"){
            private static final long serialVersionUID = 9222171216768726058L;

            public void onClick(AjaxRequestTarget target) {
                ServiceLayerConfigurationPanel.this.dialog.showInfo(target, (IModel<String>)new StringResourceModel("layerSettings", (Component)ServiceLayerConfigurationPanel.this, null), new IModel[]{new StringResourceModel("layerSettingsHelp.message", (Component)ServiceLayerConfigurationPanel.this, null)});
            }
        }});
    }

    protected ServiceResourceProvider getServiceResourceUtil() {
        return GeoServerApplication.get().getBeanOfType(ServiceResourceProvider.class);
    }

    private LoadableDetachableModel<List<String>> servicesVotedModel(final ResourceInfo resource) {
        return new LoadableDetachableModel<List<String>>(){
            private static final long serialVersionUID = 1L;

            protected List<String> load() {
                return ServiceLayerConfigurationPanel.this.getServiceResourceUtil().getServicesForResource(resource);
            }
        };
    }
}

