/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket;

import java.io.Serializable;
import java.util.Locale;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.convert.ConversionException;
import org.apache.wicket.util.convert.IConverter;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;

public class GeometryTextArea
extends TextArea<Geometry> {
    private static final long serialVersionUID = 1L;
    protected TextArea<String> geometry;

    public GeometryTextArea(String id) {
        this(id, (IModel<Geometry>)new Model(null));
    }

    public GeometryTextArea(String id, Geometry g) {
        this(id, (IModel<Geometry>)new Model((Serializable)g));
    }

    public GeometryTextArea(String id, IModel<Geometry> model) {
        super(id, model);
        this.setType(Geometry.class);
    }

    public <C> IConverter<C> getConverter(Class<C> type) {
        return new GeometryConverter();
    }

    private class GeometryConverter
    implements IConverter<Object> {
        private static final long serialVersionUID = 5868644160487841740L;
        transient GeometryFactory gf = new GeometryFactory();
        transient WKTReader reader = new WKTReader(this.gf);

        private GeometryConverter() {
        }

        public Object convertToObject(String value, Locale locale) {
            try {
                return this.reader.read(value);
            }
            catch (ParseException e) {
                try {
                    String[] values = value.split("\\s+");
                    if (values.length > 0 && values.length < 3) {
                        Coordinate c = new Coordinate();
                        c.x = Double.parseDouble(values[0]);
                        c.y = Double.parseDouble(values[1]);
                        return this.gf.createPoint(c);
                    }
                }
                catch (NumberFormatException values) {
                    // empty catch block
                }
                ConversionException ce = new ConversionException(e.getMessage());
                ce.setResourceKey(GeometryTextArea.class.getSimpleName() + ".parseError");
                throw ce;
            }
        }

        public String convertToString(Object value, Locale locale) {
            if (value instanceof Point) {
                Coordinate c = ((Point)value).getCoordinate();
                return c.x + " " + c.y;
            }
            return value.toString();
        }
    }
}

