/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.geoserver.crs.CapabilitiesCRSProvider;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geotools.gml2.SrsSyntax;
import org.geotools.referencing.CRS;

public class SRSProvider
extends GeoServerDataProvider<SRS> {
    private static final long serialVersionUID = 3731647638872356912L;
    private static Pattern NUMERIC = Pattern.compile("\\d+");
    public static final GeoServerDataProvider.Property<SRS> IDENTIFIER = new GeoServerDataProvider.BeanProperty<SRS>("identifier", "identifier"){
        private static final long serialVersionUID = -1638823520421390286L;

        @Override
        public Comparator<SRS> getComparator() {
            return new SRSIdentifierComparator();
        }
    };
    public static final GeoServerDataProvider.Property<SRS> DESCRIPTION = new GeoServerDataProvider.BeanProperty<SRS>("description", "description"){
        private static final long serialVersionUID = 3549074714488486991L;

        @Override
        public Comparator<SRS> getComparator() {
            return (o1, o2) -> String.CASE_INSENSITIVE_ORDER.compare(o1.getDescription(), o2.getDescription());
        }
    };
    private static final ArrayList<GeoServerDataProvider.Property<SRS>> PROPERTIES = new ArrayList<GeoServerDataProvider.Property>(Arrays.asList(IDENTIFIER, DESCRIPTION));
    private volatile List<SRS> items;

    public SRSProvider() {
    }

    public SRSProvider(List<String> srsList) {
        ArrayList<SRS> otherSRS = new ArrayList<SRS>();
        for (String srs : srsList) {
            otherSRS.add(new SRS(srs));
        }
        this.items = otherSRS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<SRS> getItems() {
        if (this.items == null) {
            SRSProvider sRSProvider = this;
            synchronized (sRSProvider) {
                if (this.items == null) {
                    this.items = SRSProvider.buildCodeList();
                }
            }
        }
        return this.items;
    }

    @Override
    protected List<GeoServerDataProvider.Property<SRS>> getProperties() {
        return PROPERTIES;
    }

    static List<SRS> buildCodeList() {
        return new CapabilitiesCRSProvider().getCodes().stream().map(s -> new SRS((String)s)).sorted(new SRSIdentifierComparator()).collect(Collectors.toList());
    }

    static class SRSIdentifierComparator
    implements Comparator<SRS> {
        SRSIdentifierComparator() {
        }

        @Override
        public int compare(SRS srs1, SRS srs2) {
            String s1 = SrsSyntax.AUTH_CODE.getSRS(srs1.getIdentifier());
            String s2 = SrsSyntax.AUTH_CODE.getSRS(srs2.getIdentifier());
            int idx1 = s1.indexOf(58);
            int idx2 = s2.indexOf(58);
            if (idx1 <= 0 && idx2 <= 0) {
                return s1.compareTo(s2);
            }
            if (idx1 <= 0 && idx2 > 0) {
                return -1;
            }
            if (idx1 > 0 && idx2 <= 0) {
                return 1;
            }
            String a1 = s1.substring(0, idx1);
            String a2 = s2.substring(0, idx2);
            String c1 = s1.substring(idx1 + 1);
            String c2 = s2.substring(idx2 + 1);
            int authComparison = a1.compareTo(a2);
            if (authComparison != 0) {
                return authComparison;
            }
            boolean numeric1 = NUMERIC.matcher(c1).matches();
            boolean numeric2 = NUMERIC.matcher(c2).matches();
            if (numeric1 && numeric2) {
                return (int)Math.signum(Integer.parseInt(c1) - Integer.parseInt(c2));
            }
            if (numeric1) {
                return 1;
            }
            if (numeric2) {
                return -1;
            }
            return c1.compareTo(c2);
        }
    }

    public static class SRS
    implements Serializable,
    Comparable<SRS> {
        private static final long serialVersionUID = -4155644876049747585L;
        private String identifier;
        private transient String description;

        public SRS(String identifier) {
            this.identifier = identifier;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public String getDescription() {
            if (this.description == null) {
                String desc = "-";
                try {
                    desc = CRS.getAuthorityFactory((boolean)true).getDescriptionText(this.identifier).toString();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.description = desc;
            }
            return this.description;
        }

        public boolean equals(Object o) {
            if (!(o instanceof SRS)) {
                return false;
            }
            return this.identifier.equals(((SRS)o).identifier);
        }

        public int hashCode() {
            return 17 * this.identifier.hashCode();
        }

        @Override
        public int compareTo(SRS o) {
            return this.identifier.compareTo(o.identifier);
        }
    }
}

