/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket;

import java.util.List;
import java.util.Optional;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnLoadHeaderItem;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.geoserver.web.wicket.GSModalWindow;
import org.wicketstuff.select2.Select2Behavior;

public class Select2DropDownChoice<T>
extends DropDownChoice<T> {
    private static final PackageResourceReference SELECT2_KEYBOARD_JS = new PackageResourceReference(Select2DropDownChoice.class, "js/select2/select2-keyboard.js");

    public Select2DropDownChoice(String id, IModel<T> model, IModel<List<T>> choices, IChoiceRenderer<T> renderer) {
        super(id, model, choices, renderer);
        this.initBehaviors();
    }

    public Select2DropDownChoice(String id, IModel<T> model, List<T> choices, IChoiceRenderer<T> renderer) {
        super(id, model, choices, renderer);
        this.initBehaviors();
    }

    public Select2DropDownChoice(String id, List<? extends T> choices) {
        super(id, choices);
        this.initBehaviors();
    }

    public Select2DropDownChoice(String id, List<? extends T> choices, IChoiceRenderer<? super T> renderer) {
        super(id, choices, renderer);
        this.initBehaviors();
    }

    public Select2DropDownChoice(String id, IModel<T> model, List<? extends T> choices) {
        super(id, model, choices);
        this.initBehaviors();
    }

    public Select2DropDownChoice(String id, IModel<? extends List<? extends T>> choices) {
        super(id, choices);
        this.initBehaviors();
    }

    public Select2DropDownChoice(String id, IModel<T> model, IModel<? extends List<? extends T>> choices) {
        super(id, model, choices);
        this.initBehaviors();
    }

    public Select2DropDownChoice(String id, IModel<? extends List<? extends T>> choices, IChoiceRenderer<? super T> renderer) {
        super(id, choices, renderer);
        this.initBehaviors();
    }

    private void initBehaviors() {
        this.add(new Behavior[]{new KeyboardBehavior()});
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        Optional target = this.getRequestCycle().find(AjaxRequestTarget.class);
        target.ifPresent(t -> t.prependJavaScript((CharSequence)("$('#" + this.getMarkupId() + "').select2('destroy');")));
    }

    private static class KeyboardBehavior
    extends Select2Behavior {
        public void renderHead(Component component, IHeaderResponse response) {
            super.renderHead(component, response);
            response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)SELECT2_KEYBOARD_JS));
            String enabler = "enableSelect2Keyboard('" + component.getMarkupId() + "');";
            if (KeyboardBehavior.isInModal(component)) {
                enabler = "\n  " + enabler + "\n  $('#" + component.getMarkupId() + "').select2('open');\n  $('#" + component.getMarkupId() + "').select2('close');\n";
            }
            response.render((HeaderItem)OnLoadHeaderItem.forScript((CharSequence)enabler));
        }

        private static boolean isInModal(Component component) {
            MarkupContainer parent = component.getParent();
            while (!(parent instanceof GSModalWindow)) {
                if (parent == null) {
                    return false;
                }
                parent = parent.getParent();
            }
            return true;
        }
    }
}

