/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.geoserver.catalog.Styles;
import org.geotools.util.Version;
import org.geotools.util.logging.Logging;

public class StyleFormatLabel
extends Panel {
    private static final long serialVersionUID = 6348703587354586691L;
    static final Logger LOGGER = Logging.getLogger(StyleFormatLabel.class);

    public StyleFormatLabel(String id, IModel<?> formatModel, IModel<?> versionModel) {
        super(id, formatModel);
        String formatDisplayName = this.getFormatDisplayName(formatModel);
        String majorMinorVersion = this.getMajorMinorVersionString(versionModel);
        String formatNameAndVersion = this.concateFormatNameAndVersion(formatDisplayName, majorMinorVersion);
        Label formatLabel = new Label("styleFormatLabel", (Serializable)((Object)formatNameAndVersion));
        formatLabel.add(new Behavior[]{new AttributeModifier("title", (Serializable)((Object)formatNameAndVersion))});
        this.add(new Component[]{formatLabel});
    }

    private String concateFormatNameAndVersion(String formatName, String formatVersion) {
        if (formatName == null || formatName.trim().isEmpty()) {
            return "";
        }
        if (formatVersion == null || formatVersion.trim().isEmpty()) {
            return formatName;
        }
        return formatName + " " + formatVersion;
    }

    private String getFormatDisplayName(IModel<?> formatModel) {
        if (formatModel == null || formatModel.getObject() == null) {
            return null;
        }
        String format = (String)formatModel.getObject();
        try {
            return Styles.handler((String)format).getName();
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Go an exception looking up the style handler, using the raw format instead", e);
            return format;
        }
    }

    private String getMajorMinorVersionString(IModel<?> versionModel) {
        if (versionModel == null || versionModel.getObject() == null) {
            return null;
        }
        Version formatVersion = (Version)versionModel.getObject();
        Comparable major = formatVersion.getMajor();
        Comparable minor = formatVersion.getMinor();
        if (major == null) {
            return null;
        }
        if (minor == null) {
            return major.toString();
        }
        return major.toString() + "." + minor.toString();
    }
}

