/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.demo;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.wicket.markup.html.form.ValidationErrorFeedback;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.demo.ReprojectPage;
import org.geoserver.web.wicket.ParamResourceModel;
import org.junit.Assert;
import org.junit.Test;

public class ReprojectPageTest
extends GeoServerWicketTestSupport {
    protected void setUpTestData(SystemTestData testData) throws Exception {
        testData.setUpSecurity();
    }

    @Test
    public void testReprojectPoint() {
        tester.startPage(ReprojectPage.class);
        FormTester form = tester.newFormTester("form");
        form.setValue("sourceCRS:srs", "EPSG:4326");
        form.setValue("targetCRS:srs", "EPSG:32632");
        form.setValue("sourceGeom", "12 45");
        form.submit();
        tester.clickLink("form:forward", true);
        Assert.assertEquals(ReprojectPage.class, tester.getLastRenderedPage().getClass());
        Assert.assertEquals((long)0L, (long)tester.getMessages(400).size());
        String tx = tester.getComponentFromLastRenderedPage("form:targetGeom").getDefaultModelObjectAsString();
        String[] ordinateStrings = tx.split("\\s+");
        Assert.assertEquals((double)736446.0261038465, (double)Double.parseDouble(ordinateStrings[0]), (double)1.0E-6);
        Assert.assertEquals((double)4987329.504699742, (double)Double.parseDouble(ordinateStrings[1]), (double)1.0E-6);
    }

    @Test
    public void testInvalidPoint() {
        tester.startPage(ReprojectPage.class);
        FormTester form = tester.newFormTester("form");
        form.setValue("sourceCRS:srs", "EPSG:4326");
        form.setValue("targetCRS:srs", "EPSG:32632");
        form.setValue("sourceGeom", "12 a45a");
        form.submit();
        tester.clickLink("form:forward", true);
        Assert.assertEquals(ReprojectPage.class, tester.getLastRenderedPage().getClass());
        Assert.assertEquals((long)1L, (long)tester.getMessages(400).size());
        String message = ((ValidationErrorFeedback)tester.getMessages(400).get(0)).getMessage().toString();
        String expected = new ParamResourceModel("GeometryTextArea.parseError", null, new Object[0]).getString();
        Assert.assertEquals((Object)expected, (Object)message);
    }

    @Test
    public void testReprojectLinestring() {
        tester.startPage(ReprojectPage.class);
        FormTester form = tester.newFormTester("form");
        form.setValue("sourceCRS:srs", "EPSG:4326");
        form.setValue("targetCRS:srs", "EPSG:32632");
        form.setValue("sourceGeom", "LINESTRING(12 45, 13 45)");
        form.submit();
        tester.clickLink("form:forward", true);
        Assert.assertEquals(ReprojectPage.class, tester.getLastRenderedPage().getClass());
        Assert.assertEquals((long)0L, (long)tester.getMessages(400).size());
        String tx = tester.getComponentFromLastRenderedPage("form:targetGeom").getDefaultModelObjectAsString();
        Matcher matcher = Pattern.compile("LINESTRING \\(([\\d\\.]+) ([\\d\\.]+), ([\\d\\.]+) ([\\d\\.]+)\\)").matcher(tx);
        Assert.assertTrue((String)tx, (boolean)matcher.matches());
        Assert.assertEquals((double)736446.0261038465, (double)Double.parseDouble(matcher.group(1)), (double)1.0E-6);
        Assert.assertEquals((double)4987329.504699742, (double)Double.parseDouble(matcher.group(2)), (double)1.0E-6);
        Assert.assertEquals((double)815261.4271666661, (double)Double.parseDouble(matcher.group(3)), (double)1.0E-6);
        Assert.assertEquals((double)4990738.261612577, (double)Double.parseDouble(matcher.group(4)), (double)1.0E-6);
    }

    @Test
    public void testInvalidGeometry() {
        tester.startPage(ReprojectPage.class);
        FormTester form = tester.newFormTester("form");
        form.setValue("sourceCRS:srs", "EPSG:4326");
        form.setValue("targetCRS:srs", "EPSG:32632");
        form.setValue("sourceGeom", "LINESTRING(12 45, 13 45");
        form.submit();
        tester.clickLink("form:forward", true);
        Assert.assertEquals(ReprojectPage.class, tester.getLastRenderedPage().getClass());
        Assert.assertEquals((long)1L, (long)tester.getMessages(400).size());
        String message = ((ValidationErrorFeedback)tester.getMessages(400).get(0)).getMessage().toString();
        String expected = new ParamResourceModel("GeometryTextArea.parseError", null, new Object[0]).getString();
        Assert.assertEquals((Object)expected, (Object)message);
    }

    @Test
    public void testPageParams() {
        tester.startPage(ReprojectPage.class, new PageParameters().add("fromSRS", (Object)"EPSG:4326").add("toSRS", (Object)"EPSG:32632"));
        String source = tester.getComponentFromLastRenderedPage("form:sourceCRS:srs").getDefaultModelObjectAsString();
        String target = tester.getComponentFromLastRenderedPage("form:targetCRS:srs").getDefaultModelObjectAsString();
        Assert.assertEquals((Object)"EPSG:4326", (Object)source);
        Assert.assertEquals((Object)"EPSG:32632", (Object)target);
    }
}

