/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.web.gridset;

import org.geoserver.gwc.web.gridset.GridSetBuilder;
import org.geoserver.gwc.web.gridset.GridSetInfo;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSetFactory;
import org.geowebcache.grid.SRS;
import org.junit.Assert;
import org.junit.Test;

public class GridSetBuilderTest {
    @Test
    public void testYCoordinateFirstEPSG4326() {
        GridSet epsg4326 = GridSetFactory.createGridSet((String)"GlobalCRS84Geometric", (SRS)SRS.getEPSG4326(), (BoundingBox)BoundingBox.WORLD4326, (boolean)false, (int)GridSetFactory.DEFAULT_LEVELS, null, (double)2.8E-4, (int)256, (int)256, (boolean)false);
        epsg4326.setDescription("A default WGS84 tile matrix set where the first zoom level covers the world with two tiles on the horizonal axis and one tile over the vertical axis and each subsequent zoom level is calculated by half the resolution of its previous one.");
        GridSetInfo info = new GridSetInfo(epsg4326, false);
        GridSet finalGridSet = GridSetBuilder.build((GridSetInfo)info);
        Assert.assertTrue((boolean)finalGridSet.isyCoordinateFirst());
    }

    @Test
    public void testYCoordinateFirstEPSG3857() {
        GridSet epsg3857 = GridSetFactory.createGridSet((String)"GoogleMapsCompatible", (SRS)SRS.getEPSG3857(), (BoundingBox)BoundingBox.WORLD3857, (boolean)false, (double[])this.commonPractice900913Resolutions(), null, (Double)1.0, (double)2.8E-4, null, (int)256, (int)256, (boolean)false);
        epsg3857.setDescription("This well-known scale set has been defined to be compatible with Google Maps and Microsoft Live Map projections and zoom levels. Level 0 allows representing the whole world in a single 256x256 pixels. The next level represents the whole world in 2x2 tiles of 256x256 pixels and so on in powers of 2. Scale denominator is only accurate near the equator.");
        GridSetInfo info = new GridSetInfo(epsg3857, false);
        GridSet finalGridSet = GridSetBuilder.build((GridSetInfo)info);
        Assert.assertFalse((boolean)finalGridSet.isyCoordinateFirst());
    }

    private double[] commonPractice900913Resolutions() {
        return new double[]{156543.03390625, 78271.516953125, 39135.7584765625, 19567.87923828125, 9783.939619140625, 4891.9698095703125, 2445.9849047851562, 1222.9924523925781, 611.4962261962891, 305.74811309814453, 152.87405654907226, 76.43702827453613, 38.218514137268066, 19.109257068634033, 9.554628534317017, 4.777314267158508, 2.388657133579254, 1.194328566789627, 0.5971642833948135, 0.29858214169740677, 0.14929107084870338, 0.07464553542435169, 0.037322767712175846, 0.018661383856087923, 0.009330691928043961, 0.004665345964021981, 0.0023326729820109904, 0.0011663364910054952, 5.831682455027476E-4, 2.915841227513738E-4, 1.457920613756869E-4};
    }
}

