/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.web.layer;

import java.io.Serializable;
import java.util.Locale;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.form.AbstractSingleSelectChoice;
import org.apache.wicket.markup.html.form.AbstractTextComponent;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.gwc.web.layer.CaseNormalizerSubform;
import org.geoserver.gwc.web.layer.RegexParameterFilterSubform;
import org.geoserver.web.ComponentBuilder;
import org.geoserver.web.FormTestPage;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geowebcache.filter.parameters.CaseNormalizer;
import org.geowebcache.filter.parameters.RegexParameterFilter;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;

public class RegexParameterFilterSubformTest
extends GeoServerWicketTestSupport {
    private IModel<RegexParameterFilter> model;
    private RegexParameterFilter pf;

    @Before
    public void setUpInternal() throws Exception {
        this.pf = new RegexParameterFilter();
        this.pf.setKey("TEST");
        this.model = Model.of((Serializable)this.pf);
    }

    @Test
    public void testPageLoad() {
        this.startPage();
        tester.assertComponent("form:panel:defaultValue", AbstractTextComponent.class);
        tester.assertComponent("form:panel:regex", AbstractTextComponent.class);
        tester.assertComponent("form:panel:normalize", CaseNormalizerSubform.class);
    }

    @Test
    public void testLoadDefaultValues() {
        this.startPage();
        AbstractTextComponent defaultValue = (AbstractTextComponent)tester.getComponentFromLastRenderedPage("form:panel:defaultValue");
        AbstractTextComponent regex = (AbstractTextComponent)tester.getComponentFromLastRenderedPage("form:panel:regex");
        AbstractSingleSelectChoice kase = (AbstractSingleSelectChoice)tester.getComponentFromLastRenderedPage("form:panel:normalize:case");
        AbstractSingleSelectChoice locale = (AbstractSingleSelectChoice)tester.getComponentFromLastRenderedPage("form:panel:normalize:locale");
        MatcherAssert.assertThat((Object)defaultValue.getValue(), (Matcher)Matchers.equalTo((Object)""));
        MatcherAssert.assertThat((Object)regex.getValue(), (Matcher)Matchers.equalTo((Object)""));
        MatcherAssert.assertThat((Object)kase.getValue(), (Matcher)Matchers.equalTo((Object)"NONE"));
        MatcherAssert.assertThat((Object)locale.getValue(), (Matcher)Matchers.equalTo((Object)""));
    }

    @Test
    public void testLoadSpecifiedValues() {
        this.pf.setDefaultValue("testDefault");
        this.pf.setRegex("testRegex");
        this.pf.setNormalize(new CaseNormalizer(CaseNormalizer.Case.UPPER, Locale.CANADA));
        this.startPage();
        AbstractTextComponent defaultValue = (AbstractTextComponent)tester.getComponentFromLastRenderedPage("form:panel:defaultValue");
        AbstractTextComponent regex = (AbstractTextComponent)tester.getComponentFromLastRenderedPage("form:panel:regex");
        AbstractSingleSelectChoice kase = (AbstractSingleSelectChoice)tester.getComponentFromLastRenderedPage("form:panel:normalize:case");
        AbstractSingleSelectChoice locale = (AbstractSingleSelectChoice)tester.getComponentFromLastRenderedPage("form:panel:normalize:locale");
        MatcherAssert.assertThat((Object)defaultValue.getValue(), (Matcher)Matchers.equalTo((Object)"testDefault"));
        MatcherAssert.assertThat((Object)regex.getValue(), (Matcher)Matchers.equalTo((Object)"testRegex"));
        MatcherAssert.assertThat((Object)kase.getValue(), (Matcher)Matchers.equalTo((Object)"UPPER"));
        MatcherAssert.assertThat((Object)locale.getValue(), (Matcher)Matchers.equalTo((Object)"en_CA"));
    }

    @Test
    public void testChange() {
        this.startPage();
        FormTester formTester = tester.newFormTester("form");
        formTester.setValue("panel:defaultValue", "testDefault");
        formTester.setValue("panel:regex", "testRegex");
        formTester.setValue("panel:normalize:case", "UPPER");
        formTester.setValue("panel:normalize:locale", "en_CA");
        formTester.submit();
        MatcherAssert.assertThat((Object)this.pf.getDefaultValue(), (Matcher)Matchers.equalTo((Object)"testDefault"));
        MatcherAssert.assertThat((Object)this.pf.getRegex(), (Matcher)Matchers.equalTo((Object)"testRegex"));
        MatcherAssert.assertThat((Object)this.pf.getNormalize(), (Matcher)Matchers.both((Matcher)Matchers.hasProperty((String)"case", (Matcher)Matchers.is((Object)CaseNormalizer.Case.UPPER))).and(Matchers.hasProperty((String)"locale", (Matcher)Matchers.is((Object)Locale.CANADA))));
    }

    private void startPage() {
        tester.startPage((Page)new FormTestPage(new ComponentBuilder(){
            private static final long serialVersionUID = 1L;

            public Component buildComponent(String id) {
                return new RegexParameterFilterSubform(id, RegexParameterFilterSubformTest.this.model);
            }
        }));
    }
}

