/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.web.diskquota;

import org.apache.wicket.Component;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnLoadHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;

public class StatusBar
extends Panel {
    private static final long serialVersionUID = 1L;
    private final String script;

    public StatusBar(String id, IModel<Number> limitModel, IModel<Number> progressModel, IModel<String> progressMessageModel) {
        super(id);
        int usedPercentage;
        int excessPercentage;
        this.setOutputMarkupId(true);
        WebMarkupContainer usageBar = new WebMarkupContainer("statusBarProgress");
        WebMarkupContainer excessBar = new WebMarkupContainer("statusBarExcess");
        double limit = ((Number)limitModel.getObject()).doubleValue();
        double used = ((Number)progressModel.getObject()).doubleValue();
        double excess = used - limit;
        int progressWidth = 200;
        if (excess > 0.0) {
            excessPercentage = (int)Math.round(excess * 200.0 / used);
            usedPercentage = 200 - excessPercentage;
        } else {
            usedPercentage = (int)Math.round(used * 200.0 / limit);
            excessPercentage = 0;
        }
        this.script = "document.getElementsByClassName('statusBarProgress')[0].style.width = '" + usedPercentage + "px';\ndocument.getElementsByClassName('statusBarExcess')[0].style.width = '" + excessPercentage + "px';\ndocument.getElementsByClassName('statusBarExcess')[0].style.left = '" + (5 + usedPercentage) + "px';";
        this.add(new Component[]{usageBar});
        this.add(new Component[]{excessBar});
        this.add(new Component[]{new Label("progressLabel", progressMessageModel)});
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)new PackageResourceReference(StatusBar.class, "statusbar.css")));
        response.render((HeaderItem)OnLoadHeaderItem.forScript((CharSequence)this.script));
    }
}

