/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.web.layer;

import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.link.ExternalLink;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.resource.DynamicImageResource;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.layer.GeoServerTileLayer;
import org.geoserver.gwc.web.GWCIconFactory;
import org.geoserver.gwc.web.layer.CachedLayerProvider;
import org.geoserver.gwc.web.layer.ConfigureCachedLayerAjaxLink;
import org.geoserver.gwc.web.layer.NewCachedLayerPage;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerDialog;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geoserver.web.wicket.SimpleAjaxLink;
import org.geotools.image.io.ImageIOExt;
import org.geotools.util.logging.Logging;
import org.geowebcache.diskquota.storage.Quota;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.mime.MimeType;
import org.geowebcache.seed.TruncateAllRequest;

public class CachedLayersPage
extends GeoServerSecuredPage {
    private static Logger log = Logging.getLogger(CachedLayersPage.class);
    private static final long serialVersionUID = -6795610175856538774L;
    private CachedLayerProvider provider = new CachedLayerProvider();
    private GeoServerTablePanel<TileLayer> table = new GeoServerTablePanel<TileLayer>("table", (GeoServerDataProvider)this.provider, true){
        private static final long serialVersionUID = 1L;

        protected Component getComponentForProperty(String id, IModel<TileLayer> itemModel, GeoServerDataProvider.Property<TileLayer> property) {
            if (property == CachedLayerProvider.TYPE) {
                Fragment f = new Fragment(id, "iconFragment", (MarkupContainer)CachedLayersPage.this);
                DelayedImageResource dynamicImage = new DelayedImageResource(itemModel);
                f.add(new Component[]{new Image("layerIcon", (IResource)dynamicImage, new IResource[0])});
                return f;
            }
            if (property == CachedLayerProvider.NAME) {
                return CachedLayersPage.this.nameLink(id, itemModel);
            }
            if (property == CachedLayerProvider.QUOTA_LIMIT) {
                IModel quotaLimitModel = property.getModel(itemModel);
                return CachedLayersPage.this.quotaLink(id, (IModel<Quota>)quotaLimitModel);
            }
            if (property == CachedLayerProvider.QUOTA_USAGE) {
                IModel quotaUsageModel = property.getModel(itemModel);
                return CachedLayersPage.this.quotaLink(id, (IModel<Quota>)quotaUsageModel);
            }
            if (property == CachedLayerProvider.ENABLED) {
                TileLayer layerInfo = (TileLayer)itemModel.getObject();
                boolean enabled = layerInfo.isEnabled();
                PackageResourceReference icon = enabled ? GWCIconFactory.getEnabledIcon() : GWCIconFactory.getDisabledIcon();
                Fragment f = new Fragment(id, "iconFragment", (MarkupContainer)CachedLayersPage.this);
                f.add(new Component[]{new Image("layerIcon", (ResourceReference)icon, new ResourceReference[0])});
                return f;
            }
            if (property == CachedLayerProvider.PREVIEW_LINKS) {
                return CachedLayersPage.this.previewLinks(id, itemModel);
            }
            if (property == CachedLayerProvider.ACTIONS) {
                return CachedLayersPage.this.actionsLinks(id, itemModel);
            }
            if (property == CachedLayerProvider.BLOBSTORE) {
                return null;
            }
            throw new IllegalArgumentException("Don't know a property named " + property.getName());
        }

        protected void onSelectionUpdate(AjaxRequestTarget target) {
            CachedLayersPage.this.removal.setEnabled(!CachedLayersPage.this.table.getSelection().isEmpty());
            target.add(new Component[]{CachedLayersPage.this.removal});
        }
    };
    private GeoServerDialog dialog;
    private CachedLayerSelectionRemovalLink removal;

    public CachedLayersPage() {
        this.table.setOutputMarkupId(true);
        this.add(new Component[]{this.table});
        Component[] componentArray = new Component[1];
        this.dialog = new GeoServerDialog("dialog");
        componentArray[0] = this.dialog;
        this.add(componentArray);
        this.dialog.setInitialWidth(360);
        this.dialog.setInitialHeight(180);
        this.setHeaderPanel(this.headerPanel());
        Long imageIOFileCachingThreshold = ImageIOExt.getFilesystemThreshold();
        if (null == imageIOFileCachingThreshold || 0L >= imageIOFileCachingThreshold) {
            String warningMsg = new ResourceModel("GWC.ImageIOFileCachingThresholdUnsetWarning").getObject();
            super.warn((Serializable)((Object)warningMsg));
        }
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        String script = "$('.tile-layers-page-menu-select').on('change', function(event) {\n    window.open(this.options[this.selectedIndex].value);\n    this.selectedIndex=0;\n});";
        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)script));
    }

    private Component quotaLink(String id, IModel<Quota> quotaModel) {
        Quota quota = (Quota)quotaModel.getObject();
        String formattedQuota = null == quota ? new ResourceModel("CachedLayersPage.quotaLimitNotSet").getObject() : quota.toNiceString();
        return new Label(id, (Serializable)((Object)formattedQuota));
    }

    private Component nameLink(String id, IModel<TileLayer> itemModel) {
        TileLayer layer = (TileLayer)itemModel.getObject();
        String layerName = layer.getName();
        Object link = layer instanceof GeoServerTileLayer ? new ConfigureCachedLayerAjaxLink(id, itemModel, CachedLayersPage.class) : new Label(id, (Serializable)((Object)layerName));
        return link;
    }

    private Component actionsLinks(String id, IModel<TileLayer> tileLayerNameModel) {
        String name = ((TileLayer)tileLayerNameModel.getObject()).getName();
        String baseURL = ResponseUtils.baseURL((HttpServletRequest)this.getGeoServerApplication().servletRequest());
        String href = ResponseUtils.buildURL((String)baseURL, (String)("gwc/rest/seed/" + name), null, (URLMangler.URLType)URLMangler.URLType.EXTERNAL);
        Fragment f = new Fragment(id, "actionsFragment", (MarkupContainer)this);
        f.add(new Component[]{new ExternalLink("seedLink", href, new ResourceModel("CachedLayersPage.seed").getObject())});
        f.add(new Component[]{this.truncateLink("truncateLink", tileLayerNameModel)});
        return f;
    }

    private SimpleAjaxLink<String> truncateLink(String id, IModel<TileLayer> tileLayerNameModel) {
        String layerName = ((TileLayer)tileLayerNameModel.getObject()).getName();
        Model model = new Model((Serializable)((Object)layerName));
        ResourceModel labelModel = new ResourceModel("truncate");
        SimpleAjaxLink<String> link = new SimpleAjaxLink<String>(id, (IModel)model, (IModel)labelModel){
            private static final long serialVersionUID = 1L;

            protected void onClick(AjaxRequestTarget target) {
                CachedLayersPage.this.dialog.setTitle((IModel)new ParamResourceModel("confirmTruncateTitle", (Component)CachedLayersPage.this, new Object[0]));
                CachedLayersPage.this.dialog.setDefaultModel(this.getDefaultModel());
                CachedLayersPage.this.dialog.showOkCancel(target, new GeoServerDialog.DialogDelegate(){
                    private static final long serialVersionUID = 1L;

                    protected Component getContents(String id) {
                        String layerName = this.getDefaultModelObjectAsString();
                        GWC gwcFacade = GWC.get();
                        Quota usedQuota = gwcFacade.getUsedQuota(layerName);
                        if (usedQuota == null) {
                            usedQuota = new Quota();
                        }
                        String usedQuotaStr = usedQuota.toNiceString();
                        ParamResourceModel model = new ParamResourceModel("CachedLayersPage.confirmTruncateMessage", (Component)CachedLayersPage.this, new Object[]{layerName, usedQuotaStr});
                        Label confirmLabel = new Label(id, (IModel)model);
                        confirmLabel.setEscapeModelStrings(false);
                        return confirmLabel;
                    }

                    protected boolean onSubmit(AjaxRequestTarget target, Component contents) {
                        String layerName = this.getDefaultModelObjectAsString();
                        GWC facade = GWC.get();
                        facade.truncate(layerName);
                        return true;
                    }

                    public void onClose(AjaxRequestTarget target) {
                        target.add(new Component[]{CachedLayersPage.this.table});
                    }
                });
            }
        };
        return link;
    }

    private Component previewLinks(String id, IModel<TileLayer> tileLayerModel) {
        TileLayer layer = (TileLayer)tileLayerModel.getObject();
        if (!layer.isEnabled()) {
            return new Label(id, (IModel)new ResourceModel("previewDisabled"));
        }
        TreeSet gridSubsets = new TreeSet(layer.getGridSubsets());
        ArrayList mimeTypes = new ArrayList(layer.getMimeTypes());
        Collections.sort(mimeTypes, (o1, o2) -> o1.getFormat().compareTo(o2.getFormat()));
        Fragment f = new Fragment(id, "menuFragment", (MarkupContainer)this);
        WebMarkupContainer menu = new WebMarkupContainer("menu");
        RepeatingView previewLinks = new RepeatingView("previewLink");
        String baseURL = ResponseUtils.baseURL((HttpServletRequest)this.getGeoServerApplication().servletRequest());
        Object workspaceName = "";
        if (layer.getName().contains(":")) {
            workspaceName = layer.getName().substring(0, layer.getName().indexOf(":")) + "/";
        }
        String demoURL = ResponseUtils.buildURL((String)(baseURL + (String)workspaceName), (String)("gwc/demo/" + layer.getName()), null, (URLMangler.URLType)URLMangler.URLType.EXTERNAL) + "?gridSet=";
        int i = 0;
        for (String gridSetId : gridSubsets) {
            for (MimeType mimeType : mimeTypes) {
                String label = gridSetId + " / " + mimeType.getFileExtension();
                Label format = new Label(String.valueOf(i++), (Serializable)((Object)label));
                String value = demoURL + gridSetId + "&format=" + mimeType.getFormat();
                format.add(new Behavior[]{new AttributeModifier("value", (IModel)new Model((Serializable)((Object)value)))});
                previewLinks.add(new Component[]{format});
            }
        }
        menu.add(new Component[]{previewLinks});
        f.add(new Component[]{menu});
        return f;
    }

    protected Component headerPanel() {
        Fragment header = new Fragment("headerPanel", "header", (MarkupContainer)this);
        header.add(new Component[]{new BookmarkablePageLink("addNew", NewCachedLayerPage.class)});
        Component[] componentArray = new Component[1];
        this.removal = new CachedLayerSelectionRemovalLink("removeSelected");
        componentArray[0] = this.removal;
        header.add(componentArray);
        this.removal.setOutputMarkupId(true);
        this.removal.setEnabled(false);
        header.add(new Component[]{new TruncateAllLink("clearGwcLink")});
        return header;
    }

    private class TruncateAllLink
    extends AjaxLink<String> {
        public TruncateAllLink(String id) {
            super(id);
        }

        public void onClick(AjaxRequestTarget target) {
            CachedLayersPage.this.dialog.setTitle((IModel)new ParamResourceModel("confirmGwcTruncateTitle", (Component)CachedLayersPage.this, new Object[0]));
            CachedLayersPage.this.dialog.setDefaultModel(this.getDefaultModel());
            GeoServerDialog.DialogDelegate delegate = new GeoServerDialog.DialogDelegate(){
                private TruncateAllRequest truncateAllRequest;

                protected Component getContents(String id) {
                    Label confirmLabel = new Label(id, (IModel)new ParamResourceModel("confirmGWCClean", (Component)CachedLayersPage.this, new Object[0]));
                    confirmLabel.setEscapeModelStrings(false);
                    return confirmLabel;
                }

                protected boolean onSubmit(AjaxRequestTarget target1, Component contents) {
                    GWC facade = GWC.get();
                    try {
                        this.truncateAllRequest = facade.truncateAll();
                    }
                    catch (Exception e) {
                        TruncateAllLink.this.error((Serializable)((Object)this.message("confirmGWCClean")));
                        log.log(Level.SEVERE, "An Error while clearing GWC cache", e);
                        return false;
                    }
                    return true;
                }

                private String message(String key) {
                    return new ParamResourceModel(key, (Component)CachedLayersPage.this, new Object[0]).getString();
                }

                public void onClose(AjaxRequestTarget target) {
                    target.add(new Component[]{CachedLayersPage.this.table});
                    if (this.truncateAllRequest != null) {
                        if (this.truncateAllRequest.getTrucatedLayers().length() == 0) {
                            TruncateAllLink.this.warn((Serializable)((Object)this.message("warnGWCClean")));
                        } else {
                            TruncateAllLink.this.info((Serializable)((Object)this.message("confirmGWCCleanInfo")));
                        }
                    } else {
                        TruncateAllLink.this.error((Serializable)((Object)this.message("errorGWCClean2")));
                    }
                    TruncateAllLink.this.setResponsePage((IRequestablePage)TruncateAllLink.this.getPage());
                }
            };
            CachedLayersPage.this.dialog.showOkCancel(target, delegate);
        }
    }

    private class CachedLayerSelectionRemovalLink
    extends AjaxLink<TileLayer> {
        public CachedLayerSelectionRemovalLink(String string) {
            super(string);
        }

        public void onClick(AjaxRequestTarget target) {
            List selection = CachedLayersPage.this.table.getSelection();
            if (selection.isEmpty()) {
                return;
            }
            final ArrayList<String> selectedNames = new ArrayList<String>();
            for (TileLayer layer : selection) {
                selectedNames.add(layer.getName());
            }
            CachedLayersPage.this.dialog.setTitle((IModel)new ParamResourceModel("confirmRemoval", (Component)CachedLayersPage.this, new Object[0]));
            CachedLayersPage.this.dialog.showOkCancel(target, new GeoServerDialog.DialogDelegate(){
                private static final long serialVersionUID = 1L;

                protected Component getContents(String id) {
                    GWC gwcFacade = GWC.get();
                    Quota totalQuota = new Quota();
                    for (String layerName : selectedNames) {
                        Quota usedQuota = gwcFacade.getUsedQuota(layerName);
                        if (usedQuota == null) continue;
                        totalQuota.add(usedQuota);
                    }
                    String usedQuotaStr = totalQuota.toNiceString();
                    Integer selectedLayerCount = selectedNames.size();
                    StringResourceModel model = new StringResourceModel("CachedLayersPage.confirmSelectionRemoval", (Component)CachedLayerSelectionRemovalLink.this).setParameters(new Object[]{selectedLayerCount.toString(), usedQuotaStr});
                    Label confirmLabel = new Label(id, (IModel)model);
                    confirmLabel.setEscapeModelStrings(false);
                    return confirmLabel;
                }

                protected boolean onSubmit(AjaxRequestTarget target, Component contents) {
                    GWC facade = GWC.get();
                    facade.removeTileLayers(selectedNames);
                    CachedLayersPage.this.table.clearSelection();
                    return true;
                }

                public void onClose(AjaxRequestTarget target) {
                    List selection = CachedLayersPage.this.table.getSelection();
                    if (selection.isEmpty()) {
                        CachedLayerSelectionRemovalLink.this.setEnabled(false);
                        target.add(new Component[]{CachedLayerSelectionRemovalLink.this});
                        target.add(new Component[]{CachedLayersPage.this.table});
                    }
                }
            });
        }
    }

    private static class DelayedImageResource
    extends DynamicImageResource {
        private final IModel<TileLayer> itemModel;

        public DelayedImageResource(IModel<TileLayer> itemModel) {
            super("image/png");
            this.itemModel = itemModel;
        }

        protected byte[] getImageData(IResource.Attributes attributes) {
            TileLayer layer = (TileLayer)this.itemModel.getObject();
            PackageResourceReference layerIcon = GWCIconFactory.getSpecificLayerIcon(layer);
            try {
                return IOUtils.toByteArray((InputStream)layerIcon.getResource().getResourceStream().getInputStream());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

