/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.web.layer;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.geowebcache.filter.parameters.CaseNormalizer;

public class CaseNormalizerSubform
extends FormComponentPanel<CaseNormalizer> {
    private static final long serialVersionUID = -197485768903404047L;
    private DropDownChoice<Locale> localeEntry;
    private DropDownChoice<CaseNormalizer.Case> caseEntry;

    private List<Locale> getLocales() {
        Locale[] locales = Locale.getAvailableLocales();
        Arrays.sort(locales, (o1, o2) -> o1.toString().compareTo(o2.toString()));
        return Arrays.asList(locales);
    }

    public CaseNormalizerSubform(String id, IModel<CaseNormalizer> model) {
        super(id, model);
        PropertyModel caseModel = new PropertyModel(model, "case");
        PropertyModel localeModel = new PropertyModel(model, "configuredLocale");
        this.localeEntry = new DropDownChoice("locale", (IModel)localeModel, this.getLocales(), (IChoiceRenderer)new ChoiceRenderer<Locale>(){
            private static final long serialVersionUID = -2122570049478633429L;

            public Object getDisplayValue(Locale object) {
                return object.getDisplayName(CaseNormalizerSubform.this.getLocale());
            }

            public String getIdValue(Locale object, int index) {
                return object.toString();
            }
        });
        this.localeEntry.setNullValid(true);
        this.caseEntry = new DropDownChoice("case", (IModel)caseModel, Arrays.asList(CaseNormalizer.Case.values()), (IChoiceRenderer)new ChoiceRenderer<CaseNormalizer.Case>(){
            private static final long serialVersionUID = -129788130907421097L;

            public Object getDisplayValue(CaseNormalizer.Case object) {
                return CaseNormalizerSubform.this.getLocalizer().getString("case." + object.name(), (Component)CaseNormalizerSubform.this);
            }

            public String getIdValue(CaseNormalizer.Case object, int index) {
                return object.name();
            }
        });
        this.add(new Component[]{this.caseEntry});
        this.add(new Component[]{this.localeEntry});
    }

    public void convertInput() {
        this.visitChildren((component, visit) -> {
            if (component instanceof FormComponent) {
                FormComponent formComponent = (FormComponent)component;
                formComponent.processInput();
            }
        });
        CaseNormalizer filter = (CaseNormalizer)this.getModelObject();
        this.setConvertedInput(filter);
    }
}

