/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.web.layer;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.CheckBoxMultipleChoice;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.geoserver.gwc.layer.StyleParameterFilter;
import org.geoserver.gwc.web.layer.AbstractParameterFilterSubform;

public class StyleParameterFilterSubform
extends AbstractParameterFilterSubform<StyleParameterFilter> {
    private static final long serialVersionUID = 1L;

    public StyleParameterFilterSubform(String id, IModel<StyleParameterFilter> model) {
        super(id, model);
    }

    public void onInitialize() {
        super.onInitialize();
        String allStyles = this.getLocalizer().getString("allStyles", (Component)this);
        String layerDefault = this.getLocalizer().getString("layerDefault", (Component)this);
        SetAsListModel availableStylesModelDefault = new SetAsListModel((IModel<Set<String>>)new PropertyModel((Object)this.getModel(), "layerStyles"), layerDefault);
        SetAsListModel availableStylesModelAllowed = new SetAsListModel((IModel<Set<String>>)new PropertyModel((Object)this.getModel(), "layerStyles"), allStyles);
        NullableSetAsListModel selectedStylesModel = new NullableSetAsListModel((IModel<Set<String>>)new PropertyModel((Object)this.getModel(), "styles"), allStyles);
        LabelledEmptyStringModel selectedDefaultModel = new LabelledEmptyStringModel((IModel<String>)new PropertyModel((Object)this.getModel(), "realDefault"), layerDefault);
        DropDownChoice defaultValue = new DropDownChoice("defaultValue", (IModel)selectedDefaultModel, (IModel)availableStylesModelDefault);
        this.add(new Component[]{defaultValue});
        CheckBoxMultipleChoice styles = new CheckBoxMultipleChoice("styles", (IModel)selectedStylesModel, (IModel)availableStylesModelAllowed);
        styles.setPrefix("<li>");
        styles.setSuffix("</li>");
        this.add(new Component[]{styles});
    }

    static class NullableSetAsListModel
    implements IModel<List<String>> {
        private static final long serialVersionUID = 1L;
        private final IModel<Set<String>> realModel;
        private final List<String> fakeObject;
        protected final String nullify;

        public NullableSetAsListModel(IModel<Set<String>> realModel, String nullify) {
            this.realModel = realModel;
            this.nullify = nullify;
            Set realObj = (Set)realModel.getObject();
            int size = realObj == null ? 1 : realObj.size();
            this.fakeObject = new ArrayList<String>(size);
        }

        public void detach() {
            this.realModel.detach();
        }

        public List<String> getObject() {
            Set realObj = (Set)this.realModel.getObject();
            this.fakeObject.clear();
            if (realObj != null) {
                this.fakeObject.addAll(realObj);
            } else {
                this.fakeObject.add(this.nullify);
            }
            return this.fakeObject;
        }

        public void setObject(List<String> object) {
            if (object == null || object.contains(this.nullify)) {
                this.realModel.setObject(null);
            } else {
                HashSet<String> newObj = new HashSet<String>(object);
                newObj.remove(this.nullify);
                this.realModel.setObject(new HashSet<String>(object));
            }
        }
    }

    static class LabelledEmptyStringModel
    implements IModel<String> {
        private static final long serialVersionUID = 7591957769540603345L;
        private final IModel<String> realModel;
        final String label;

        public LabelledEmptyStringModel(IModel<String> realModel, String label) {
            this.realModel = realModel;
            this.label = label;
        }

        public void detach() {
            this.realModel.detach();
        }

        public String getObject() {
            String s = (String)this.realModel.getObject();
            if (s == null || s.isEmpty()) {
                return this.label;
            }
            return s;
        }

        public void setObject(String object) {
            if (this.label.equals(object)) {
                this.realModel.setObject((Object)"");
            } else {
                this.realModel.setObject((Object)object);
            }
        }
    }

    static class SetAsListModel
    implements IModel<List<String>> {
        private static final long serialVersionUID = 1L;
        private final IModel<Set<String>> realModel;
        private final List<String> fakeObject;
        protected final String extra;

        public SetAsListModel(IModel<Set<String>> realModel, String extra) {
            this.realModel = realModel;
            this.extra = extra;
            Set realObj = (Set)realModel.getObject();
            int size = realObj == null ? 0 : realObj.size();
            if (extra != null) {
                ++size;
            }
            this.fakeObject = new ArrayList<String>(size);
        }

        public void detach() {
            this.realModel.detach();
        }

        public List<String> getObject() {
            Set realObj = (Set)this.realModel.getObject();
            this.fakeObject.clear();
            if (this.extra != null) {
                this.fakeObject.add(this.extra);
            }
            if (realObj != null) {
                this.fakeObject.addAll(realObj);
            }
            return this.fakeObject;
        }

        public void setObject(List<String> object) {
            if (object == null) {
                this.realModel.setObject(null);
            } else {
                HashSet<String> newObj = new HashSet<String>(object);
                newObj.remove(this.extra);
                this.realModel.setObject(new HashSet<String>(object));
            }
        }
    }
}

