/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.web.layer;

import java.io.Serializable;
import java.util.Locale;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.form.AbstractSingleSelectChoice;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.gwc.web.layer.CaseNormalizerSubform;
import org.geoserver.web.ComponentBuilder;
import org.geoserver.web.FormTestPage;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geowebcache.filter.parameters.CaseNormalizer;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;

public class CaseNormalizerSubformTest
extends GeoServerWicketTestSupport {
    private IModel<CaseNormalizer> model;
    private CaseNormalizer cn;

    @Before
    public void setUpInternal() throws Exception {
        this.cn = new CaseNormalizer();
        this.model = Model.of((Serializable)this.cn);
    }

    @Test
    public void testPageLoad() {
        this.startPage();
        tester.assertComponent("form:panel:case", AbstractSingleSelectChoice.class);
        tester.assertComponent("form:panel:locale", AbstractSingleSelectChoice.class);
        AbstractSingleSelectChoice kase = (AbstractSingleSelectChoice)tester.getComponentFromLastRenderedPage("form:panel:case");
        AbstractSingleSelectChoice locale = (AbstractSingleSelectChoice)tester.getComponentFromLastRenderedPage("form:panel:locale");
        MatcherAssert.assertThat((Object)kase.isNullValid(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)locale.isNullValid(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testLoadDefaultValues() {
        this.startPage();
        AbstractSingleSelectChoice kase = (AbstractSingleSelectChoice)tester.getComponentFromLastRenderedPage("form:panel:case");
        AbstractSingleSelectChoice locale = (AbstractSingleSelectChoice)tester.getComponentFromLastRenderedPage("form:panel:locale");
        MatcherAssert.assertThat((Object)kase.getValue(), (Matcher)Matchers.equalTo((Object)"NONE"));
        MatcherAssert.assertThat((Object)locale.getValue(), (Matcher)Matchers.equalTo((Object)""));
    }

    @Test
    public void testLoadSpecifiedValues() {
        this.cn = new CaseNormalizer(CaseNormalizer.Case.UPPER, Locale.CANADA);
        this.model = Model.of((Serializable)this.cn);
        this.startPage();
        AbstractSingleSelectChoice kase = (AbstractSingleSelectChoice)tester.getComponentFromLastRenderedPage("form:panel:case");
        AbstractSingleSelectChoice locale = (AbstractSingleSelectChoice)tester.getComponentFromLastRenderedPage("form:panel:locale");
        MatcherAssert.assertThat((Object)kase.getValue(), (Matcher)Matchers.equalTo((Object)"UPPER"));
        MatcherAssert.assertThat((Object)locale.getValue(), (Matcher)Matchers.equalTo((Object)"en_CA"));
    }

    @Test
    public void testChangeFromDefault() {
        this.startPage();
        FormTester formTester = tester.newFormTester("form");
        formTester.setValue("panel:case", "UPPER");
        formTester.setValue("panel:locale", "en_CA");
        formTester.submit();
        MatcherAssert.assertThat((Object)this.cn.getCase(), (Matcher)Matchers.is((Object)CaseNormalizer.Case.UPPER));
        MatcherAssert.assertThat((Object)this.cn.getConfiguredLocale(), (Matcher)Matchers.is((Object)Locale.CANADA));
    }

    @Test
    public void testChange() {
        this.cn = new CaseNormalizer(CaseNormalizer.Case.LOWER, Locale.TAIWAN);
        this.model = Model.of((Serializable)this.cn);
        this.startPage();
        FormTester formTester = tester.newFormTester("form");
        formTester.setValue("panel:case", "UPPER");
        formTester.setValue("panel:locale", "en_CA");
        formTester.submit();
        MatcherAssert.assertThat((Object)this.cn.getCase(), (Matcher)Matchers.is((Object)CaseNormalizer.Case.UPPER));
        MatcherAssert.assertThat((Object)this.cn.getConfiguredLocale(), (Matcher)Matchers.is((Object)Locale.CANADA));
    }

    @Test
    public void testChangeToDefault() {
        this.cn = new CaseNormalizer(CaseNormalizer.Case.LOWER, Locale.TAIWAN);
        this.model = Model.of((Serializable)this.cn);
        this.startPage();
        FormTester formTester = tester.newFormTester("form");
        formTester.setValue("panel:case", "NONE");
        formTester.setValue("panel:locale", "-1");
        formTester.submit();
        MatcherAssert.assertThat((Object)this.cn.getCase(), (Matcher)Matchers.is((Object)CaseNormalizer.Case.NONE));
        MatcherAssert.assertThat((Object)this.cn.getConfiguredLocale(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)this.cn.getLocale(), (Matcher)Matchers.instanceOf(Locale.class));
    }

    private void startPage() {
        tester.startPage((Page)new FormTestPage(new ComponentBuilder(){
            private static final long serialVersionUID = 1L;

            public Component buildComponent(String id) {
                return new CaseNormalizerSubform(id, CaseNormalizerSubformTest.this.model);
            }
        }));
    }
}

