/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.web;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.string.Strings;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.web.GWCIconFactory;
import org.geoserver.gwc.web.gridset.GridSetListTablePanel;
import org.geoserver.gwc.web.gridset.GridSetTableProvider;
import org.geoserver.web.wicket.GeoServerAjaxFormLink;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.Icon;
import org.geoserver.web.wicket.ImageAjaxLink;
import org.geoserver.web.wicket.Select2DropDownChoice;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSetBroker;

class DefaultGridsetsEditor
extends FormComponentPanel<Set<String>> {
    private static final long serialVersionUID = 5098470663723800345L;
    private final IModel<? extends List<String>> selection;
    private DefaultGridSetsTable defaultGridsetsTable;
    private final DropDownChoice<String> availableGridSets;

    public DefaultGridsetsEditor(String id, IModel<Set<String>> model) {
        super(id, model);
        this.selection = new Model(new ArrayList((Collection)model.getObject()));
        GridSetTableProvider provider = new GridSetTableProvider(){
            private static final long serialVersionUID = 1L;

            @Override
            public List<GridSet> getItems() {
                GridSetBroker gridSetBroker = GWC.get().getGridSetBroker();
                List list = (List)DefaultGridsetsEditor.this.selection.getObject();
                ArrayList<GridSet> gridsets = new ArrayList<GridSet>(list.size());
                for (String id : list) {
                    GridSet gridSet = gridSetBroker.get(id);
                    if (gridSet == null) continue;
                    gridsets.add(gridSet);
                }
                return gridsets;
            }
        };
        this.defaultGridsetsTable = new DefaultGridSetsTable("table", provider);
        this.add(new Component[]{this.defaultGridsetsTable});
        LoadableDetachableModel<List<String>> availableModel = new LoadableDetachableModel<List<String>>(){
            private static final long serialVersionUID = 1L;

            protected List<String> load() {
                ArrayList<String> gridSetNames = new ArrayList<String>(GWC.get().getGridSetBroker().getNames());
                for (String gsId : (List)DefaultGridsetsEditor.this.selection.getObject()) {
                    gridSetNames.remove(gsId);
                }
                Collections.sort(gridSetNames);
                return gridSetNames;
            }
        };
        this.availableGridSets = new Select2DropDownChoice("availableGridsets", (IModel)new Model(), (IModel)availableModel);
        this.availableGridSets.setOutputMarkupId(true);
        this.add(new Component[]{this.availableGridSets});
        GeoServerAjaxFormLink addGridsubsetLink = new GeoServerAjaxFormLink("addGridset"){
            private static final long serialVersionUID = 1L;

            protected void onClick(AjaxRequestTarget target, Form<?> form) {
                DefaultGridsetsEditor.this.availableGridSets.processInput();
                String selectedGridset = (String)DefaultGridsetsEditor.this.availableGridSets.getModelObject();
                if (null == selectedGridset) {
                    return;
                }
                ArrayList choices = new ArrayList(DefaultGridsetsEditor.this.availableGridSets.getChoices());
                choices.remove(selectedGridset);
                DefaultGridsetsEditor.this.availableGridSets.setChoices(choices);
                DefaultGridsetsEditor.this.availableGridSets.setEnabled(!choices.isEmpty());
                List selectedIds = (List)DefaultGridsetsEditor.this.selection.getObject();
                selectedIds.add(selectedGridset);
                DefaultGridsetsEditor.this.defaultGridsetsTable.setPageable(false);
                target.add(new Component[]{DefaultGridsetsEditor.this.defaultGridsetsTable});
                target.add(new Component[]{DefaultGridsetsEditor.this.availableGridSets});
            }
        };
        addGridsubsetLink.add(new Component[]{new Icon("addIcon", GWCIconFactory.ADD_ICON)});
        this.add(new Component[]{addGridsubsetLink});
    }

    public void convertInput() {
        List defaultGridsetIds = (List)this.selection.getObject();
        HashSet convertedInput = new HashSet();
        convertedInput.addAll(defaultGridsetIds);
        this.setConvertedInput(convertedInput);
    }

    protected void onBeforeRender() {
        super.onBeforeRender();
    }

    private class DefaultGridSetsTable
    extends GridSetListTablePanel {
        private static final long serialVersionUID = -3301795024743630393L;

        public DefaultGridSetsTable(String id, GridSetTableProvider provider) {
            super(id, provider, false);
            this.setOutputMarkupId(true);
            this.setPageable(false);
            this.setFilterable(false);
        }

        @Override
        protected Component nameLink(String id, GridSet gridSet) {
            Label label = new Label(id, (Serializable)((Object)gridSet.getName()));
            label.add(new Behavior[]{new AttributeModifier("title", (IModel)new Model((Serializable)((Object)gridSet.getDescription())))});
            return label;
        }

        @Override
        protected Component actionLink(String id, String gridSetName) {
            ImageAjaxLink removeLink = new ImageAjaxLink(id, GWCIconFactory.DELETE_ICON){
                private static final long serialVersionUID = 1L;

                protected void onClick(AjaxRequestTarget target) {
                    String gridsetName = this.getDefaultModelObjectAsString();
                    List selection = (List)DefaultGridsetsEditor.this.selection.getObject();
                    selection.remove(gridsetName);
                    ArrayList<String> choices = new ArrayList<String>(DefaultGridsetsEditor.this.availableGridSets.getChoices());
                    choices.add(gridsetName);
                    Collections.sort(choices);
                    DefaultGridsetsEditor.this.availableGridSets.setChoices(choices);
                    target.add(new Component[]{DefaultGridsetsEditor.this.defaultGridsetsTable});
                    target.add(new Component[]{DefaultGridsetsEditor.this.availableGridSets});
                }
            };
            removeLink.setDefaultModel((IModel)new Model((Serializable)((Object)gridSetName)));
            return removeLink;
        }

        @Override
        protected Component getComponentForProperty(String id, IModel<GridSet> itemModel, GeoServerDataProvider.Property<GridSet> property) {
            String propertyName = property.getName();
            if (Strings.isEmpty((String)propertyName)) {
                return this.actionLink(id, ((GridSet)itemModel.getObject()).getName());
            }
            return null;
        }
    }
}

