/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.web.gridset;

import java.io.Serializable;
import java.util.logging.Level;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.web.gridset.AbstractGridSetPage;
import org.geoserver.gwc.web.gridset.GridSetInfo;
import org.geoserver.gwc.web.gridset.GridSetsPage;
import org.geowebcache.grid.GridSet;

public class GridSetEditPage
extends AbstractGridSetPage {
    private static final long serialVersionUID = 1748616637023642755L;
    private String originalName;

    public GridSetEditPage(PageParameters parameters) {
        super(parameters);
        GridSetInfo info = (GridSetInfo)this.form.getModelObject();
        this.originalName = info.getName();
        if (info.isInternal()) {
            this.form.info((Serializable)((Object)new ResourceModel("GridSetEditPage.internalGridSetMessage").getObject()));
            this.name.getFormComponent().setEnabled(false);
            this.description.setEnabled(false);
            this.crs.setEnabled(false);
            this.tileWidth.getFormComponent().setEnabled(false);
            this.tileHeight.getFormComponent().setEnabled(false);
            this.bounds.setEnabled(false);
            this.computeBoundsLink.setEnabled(false);
            this.tileMatrixSetEditor.setEnabled(false);
            this.saveLink.setVisible(false);
            this.addLevelLink.setVisible(false);
        }
    }

    @Override
    protected void onSave(AjaxRequestTarget target, Form<?> form) {
        GridSetInfo info = (GridSetInfo)form.getModelObject();
        GridSet newGridset = null;
        try {
            newGridset = this.toGridSet(target, form, info);
        }
        catch (Exception e) {
            form.error((Serializable)((Object)e.getMessage()));
            target.add(new Component[]{form});
            return;
        }
        try {
            GWC gwc = GWC.get();
            gwc.modifyGridSet(this.originalName, newGridset);
            this.doReturn(GridSetsPage.class);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "", e);
            form.error((Serializable)((Object)("Error saving gridset: " + e.getMessage())));
            target.add(new Component[]{form});
        }
    }
}

