/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.web.layer;

import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.gwc.layer.GeoServerTileLayer;
import org.geoserver.gwc.web.layer.LayerCacheOptionsTabPanel;
import org.geoserver.web.data.layergroup.LayerGroupEditPage;
import org.geoserver.web.data.resource.ResourceConfigurationPage;
import org.geoserver.web.wicket.SimpleAjaxLink;
import org.geowebcache.layer.TileLayer;

class ConfigureCachedLayerAjaxLink
extends SimpleAjaxLink<TileLayer> {
    private static final long serialVersionUID = 1L;
    private Class<? extends Page> returnPage;

    public ConfigureCachedLayerAjaxLink(String id, IModel<TileLayer> itemModel, Class<? extends Page> returnPage) {
        super(id, itemModel, (IModel)new PropertyModel(itemModel, "name"));
        this.returnPage = returnPage;
    }

    protected void onClick(AjaxRequestTarget target) {
        TileLayer layer = (TileLayer)this.getModelObject();
        if (!(layer instanceof GeoServerTileLayer)) {
            return;
        }
        GeoServerTileLayer geoserverTileLayer = (GeoServerTileLayer)this.getModelObject();
        PublishedInfo publishedInfo = geoserverTileLayer.getPublishedInfo();
        if (publishedInfo instanceof LayerInfo) {
            ResourceConfigurationPage resourceConfigPage = new ResourceConfigurationPage((LayerInfo)publishedInfo, false);
            resourceConfigPage.setSelectedTab(LayerCacheOptionsTabPanel.class);
            if (this.returnPage != null) {
                resourceConfigPage.setReturnPage(this.returnPage);
            }
            this.setResponsePage((IRequestablePage)resourceConfigPage);
        } else if (publishedInfo instanceof LayerGroupInfo) {
            LayerGroupInfo layerGroup = (LayerGroupInfo)publishedInfo;
            WorkspaceInfo workspace = layerGroup.getWorkspace();
            String wsName = workspace == null ? null : workspace.getName();
            PageParameters parameters = new PageParameters();
            parameters.add("group", (Object)layerGroup.getName());
            if (wsName != null) {
                parameters.add("workspace", (Object)wsName);
            }
            LayerGroupEditPage layerGroupEditPage = new LayerGroupEditPage(parameters);
            if (this.returnPage != null) {
                layerGroupEditPage.setReturnPage(this.returnPage);
            }
            this.setResponsePage((IRequestablePage)layerGroupEditPage);
        }
    }
}

