/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.web;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.link.ExternalLink;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.layer.GeoServerTileLayer;
import org.geoserver.gwc.web.GWCServiceDescriptionProvider;
import org.geoserver.gwc.wmts.WMTSInfo;
import org.geoserver.ows.util.KvpUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.web.GeoServerHomePage;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.ServiceDescription;
import org.geoserver.web.ServiceLinkDescription;
import org.junit.Assert;
import org.junit.Test;

public class GWCServiceLinksTest
extends GeoServerWicketTestSupport {
    @Test
    public void testCapabilitiesLinks() {
        GeoServerHomePage page = new GeoServerHomePage();
        tester.startPage((Page)page);
        tester.assertRenderedPage(GeoServerHomePage.class);
        Page lastPage = tester.getLastRenderedPage();
        ArrayList services = new ArrayList();
        lastPage.visitChildren(ExternalLink.class, (component, visit) -> {
            String url = (String)component.getDefaultModelObject();
            if (url != null) {
                Map params;
                String service;
                if (url.startsWith("../gwc/service/")) {
                    int idx = url.indexOf("?");
                    String service2 = idx > 0 ? url.substring("./gwc/service/".length() + 1, idx) : url.substring("./gwc/service/".length() + 1);
                    if (service2 != null) {
                        services.add(service2);
                    }
                } else if (url.contains("GetCapabilities") && (service = (String)(params = KvpUtils.parseQueryString((String)url)).get("service")) != null) {
                    services.add(service);
                }
            }
        });
        Assert.assertFalse((boolean)services.contains("gwc"));
        Assert.assertTrue((boolean)services.contains("wmts"));
        Assert.assertTrue((boolean)services.contains("wms"));
        Assert.assertTrue((boolean)services.contains("tms/1.0.0"));
    }

    @Test
    public void serviceDescriptorAndLinks() {
        GWCServiceDescriptionProvider provider = (GWCServiceDescriptionProvider)GeoServerExtensions.bean(GWCServiceDescriptionProvider.class);
        List services = provider.getServices(null, null);
        List links = provider.getServiceLinks(null, null);
        Assert.assertEquals((long)1L, (long)services.size());
        ServiceDescription wfs = (ServiceDescription)services.get(0);
        boolean wmsFound = false;
        boolean wmtsFound = false;
        for (ServiceLinkDescription link : links) {
            Assert.assertEquals((String)"crosslink", (Object)wfs.getServiceType(), (Object)link.getServiceType());
            String protocol = link.getProtocol();
            if (protocol.equals("WMS-C")) {
                Assert.assertTrue((String)"version", (boolean)link.getLink().contains("version=1.1.1"));
                Assert.assertTrue((String)"service", (boolean)link.getLink().contains("service=WMS"));
                wmsFound = true;
                continue;
            }
            if (!protocol.equals("WMTS")) continue;
            Assert.assertTrue((String)"version", (boolean)link.getLink().contains("acceptVersions=1.0.0"));
            Assert.assertTrue((String)"service", (boolean)link.getLink().contains("service=WMTS"));
            wmtsFound = true;
        }
        Assert.assertTrue((boolean)wmsFound);
        Assert.assertTrue((boolean)wmtsFound);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void availableServiceCheck() {
        GWCServiceDescriptionProvider provider = (GWCServiceDescriptionProvider)GeoServerExtensions.bean(GWCServiceDescriptionProvider.class);
        Catalog catalog = this.getCatalog();
        GeoServer geoServer = this.getGeoServer();
        GeoServerInfo global = geoServer.getGlobal();
        WMTSInfo wmts = (WMTSInfo)geoServer.getService(WMTSInfo.class);
        GWC gwc = GWC.get();
        WorkspaceInfo cite = catalog.getWorkspaceByName("cite");
        LayerInfo buildings = catalog.getLayerByName("Buildings");
        String tileLayerName = buildings.getResource().prefixedName();
        GeoServerTileLayer tileLayer = (GeoServerTileLayer)gwc.getTileLayerByName(tileLayerName);
        try {
            List services = provider.getServices(null, null).stream().filter(s -> s.isAvailable()).collect(Collectors.toList());
            Assert.assertEquals((long)1L, (long)services.size());
            services = provider.getServices(cite, null).stream().filter(s -> s.isAvailable()).collect(Collectors.toList());
            Assert.assertEquals((long)1L, (long)services.size());
            services = provider.getServices(cite, (PublishedInfo)buildings).stream().filter(s -> s.isAvailable()).collect(Collectors.toList());
            Assert.assertEquals((long)1L, (long)services.size());
            global.setGlobalServices(Boolean.valueOf(false));
            geoServer.save(global);
            services = provider.getServices(null, null).stream().filter(s -> s.isAvailable()).collect(Collectors.toList());
            Assert.assertEquals((long)0L, (long)services.size());
            services = provider.getServices(cite, null).stream().filter(s -> s.isAvailable()).collect(Collectors.toList());
            Assert.assertEquals((long)1L, (long)services.size());
            services = provider.getServices(cite, (PublishedInfo)buildings).stream().filter(s -> s.isAvailable()).collect(Collectors.toList());
            Assert.assertEquals((long)1L, (long)services.size());
            global.setGlobalServices(Boolean.valueOf(true));
            geoServer.save(global);
            services = provider.getServices(null, null).stream().filter(s -> s.isAvailable()).collect(Collectors.toList());
            Assert.assertEquals((long)1L, (long)services.size());
            services = provider.getServices(cite, null).stream().filter(s -> s.isAvailable()).collect(Collectors.toList());
            Assert.assertEquals((long)1L, (long)services.size());
            services = provider.getServices(cite, (PublishedInfo)buildings).stream().filter(s -> s.isAvailable()).collect(Collectors.toList());
            Assert.assertEquals((long)1L, (long)services.size());
            wmts.setEnabled(false);
            geoServer.save((ServiceInfo)wmts);
            services = provider.getServices(null, null).stream().filter(s -> s.isAvailable()).collect(Collectors.toList());
            Assert.assertEquals((long)0L, (long)services.size());
            services = provider.getServices(cite, null).stream().filter(s -> s.isAvailable()).collect(Collectors.toList());
            Assert.assertEquals((long)0L, (long)services.size());
            services = provider.getServices(cite, (PublishedInfo)buildings).stream().filter(s -> s.isAvailable()).collect(Collectors.toList());
            Assert.assertEquals((long)0L, (long)services.size());
            wmts.setEnabled(true);
            geoServer.save((ServiceInfo)wmts);
            Assert.assertTrue((String)"has tilt layer", (boolean)gwc.hasTileLayer((CatalogInfo)buildings));
            services = provider.getServices(cite, (PublishedInfo)buildings).stream().filter(s -> s.isAvailable()).collect(Collectors.toList());
            Assert.assertEquals((long)1L, (long)services.size());
            gwc.removeTileLayers(Arrays.asList("cite:Buildings"));
            Assert.assertFalse((String)"no tilelayer", (boolean)gwc.hasTileLayer((CatalogInfo)buildings));
            services = provider.getServices(cite, (PublishedInfo)buildings).stream().filter(s -> s.isAvailable()).collect(Collectors.toList());
            Assert.assertEquals((long)0L, (long)services.size());
        }
        finally {
            global.setGlobalServices(Boolean.valueOf(true));
            geoServer.save(global);
            wmts.setEnabled(true);
            geoServer.save((ServiceInfo)wmts);
            if (!gwc.tileLayerExists(tileLayerName)) {
                gwc.add(tileLayer);
            }
        }
    }
}

