/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web;

import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.geoserver.security.web.AbstractSecurityWicketTestSupport;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractListPageTest<T>
extends AbstractSecurityWicketTestSupport {
    public static final String ITEMS_PATH = "table:listContainer:items";
    public static final String FIRST_COLUM_PATH = "itemProperties:0:component:link";

    @Override
    @Before
    public void setUp() throws Exception {
        this.login();
    }

    @Test
    public void testRenders() throws Exception {
        this.initializeForXML();
        tester.startPage(this.listPage(null));
        tester.assertRenderedPage(this.listPage(null).getClass());
    }

    protected abstract Page listPage(PageParameters var1);

    protected abstract Page newPage(Object ... var1);

    protected abstract Page editPage(Object ... var1);

    protected abstract String getSearchString() throws Exception;

    protected abstract GeoServerDataProvider.Property<T> getEditProperty();

    protected abstract boolean checkEditForm(String var1);

    @Test
    public void testEdit() throws Exception {
        this.initializeForXML();
        tester.startPage(this.listPage(null));
        String search = this.getSearchString();
        Assert.assertNotNull((Object)search);
        Component c = this.getFromList(FIRST_COLUM_PATH, search, this.getEditProperty());
        Assert.assertNotNull((Object)c);
        tester.clickLink(c.getPageRelativePath());
        tester.assertRenderedPage(this.editPage(new Object[0]).getClass());
        Assert.assertTrue((boolean)this.checkEditForm(search));
    }

    protected Component getFromList(String columnPath, Object columnValue, GeoServerDataProvider.Property<T> property) {
        MarkupContainer listView = (MarkupContainer)tester.getLastRenderedPage().get(ITEMS_PATH);
        for (Component container : listView) {
            Component c = container.get(columnPath);
            Object modelObject = c.getDefaultModelObject();
            if (!columnValue.equals(property.getPropertyValue(modelObject))) continue;
            return c;
        }
        return null;
    }

    @Test
    public void testNew() throws Exception {
        this.initializeForXML();
        tester.startPage(this.listPage(null));
        tester.clickLink("headerPanel:addNew");
        Page newPage = tester.getLastRenderedPage();
        tester.assertRenderedPage(newPage.getClass());
    }

    @Test
    public void testRemove() throws Exception {
        this.initializeForXML();
        this.insertValues();
        this.addAdditonalData();
        this.doRemove("headerPanel:removeSelected");
    }

    protected void doRemove(String pathForLink) throws Exception {
        Page testPage = tester.startPage(this.listPage(null));
        String selectAllPath = "table:listContainer:selectAllContainer:selectAll";
        tester.assertComponent(selectAllPath, CheckBox.class);
        CheckBox selectAllComponent = (CheckBox)tester.getComponentFromLastRenderedPage(selectAllPath);
        this.setFormComponentValue((FormComponent)selectAllComponent, "true");
        tester.executeAjaxEvent(selectAllPath, "click");
        ModalWindow w = (ModalWindow)tester.getLastRenderedPage().get("dialog:dialog");
        Assert.assertNull((Object)w.getTitle());
        tester.executeAjaxEvent(pathForLink, "click");
        Assert.assertNotNull((Object)w.getTitle());
        this.simulateDeleteSubmit();
        this.executeModalWindowCloseButtonCallback(w);
    }

    protected abstract void simulateDeleteSubmit() throws Exception;

    protected Component getRemoveLink() {
        Component result = tester.getLastRenderedPage().get("headerPanel:removeSelected");
        Assert.assertNotNull((Object)result);
        return result;
    }

    protected Component getRemoveLinkWithRoles() {
        Component result = tester.getLastRenderedPage().get("headerPanel:removeSelectedWithRoles");
        Assert.assertNotNull((Object)result);
        return result;
    }

    protected Component getAddLink() {
        Component result = tester.getLastRenderedPage().get("headerPanel:addNew");
        Assert.assertNotNull((Object)result);
        return result;
    }
}

