/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.passwd;

import java.net.URL;
import java.util.SortedSet;
import org.apache.wicket.Component;
import org.geoserver.security.password.MasterPasswordProviderConfig;
import org.geoserver.security.password.URLMasterPasswordProvider;
import org.geoserver.security.password.URLMasterPasswordProviderConfig;
import org.geoserver.security.web.AbstractSecurityNamedServicePanelTest;
import org.geoserver.security.web.AbstractSecurityPage;
import org.geoserver.security.web.SecurityNamedServiceEditPage;
import org.geoserver.security.web.SecurityNamedServiceNewPage;
import org.geoserver.security.web.passwd.MasterPasswordProvidersPanel;
import org.geoserver.security.web.passwd.PasswordPage;
import org.geoserver.security.web.passwd.URLMasterPasswordProviderPanelInfo;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MasterPasswordProviderPanelTest
extends AbstractSecurityNamedServicePanelTest {
    @Before
    public void clearSecurityStuff() throws Exception {
        SortedSet mpProviders = this.getSecurityManager().listMasterPasswordProviders();
        if (mpProviders.contains("default2")) {
            MasterPasswordProviderConfig default2 = this.getSecurityManager().loadMasterPassswordProviderConfig("default2");
            this.getSecurityManager().removeMasterPasswordProvder(default2);
        }
    }

    @Override
    protected AbstractSecurityPage getBasePage() {
        return new PasswordPage();
    }

    @Override
    protected String getBasePanelId() {
        return "form:masterPasswordProviders";
    }

    @Override
    protected Integer getTabIndex() {
        return null;
    }

    @Override
    protected Class<? extends Component> getNamedServicesClass() {
        return MasterPasswordProvidersPanel.class;
    }

    @Override
    protected String getDetailsFormComponentId() {
        return null;
    }

    @Test
    public void testAddModify() throws Exception {
        this.initializeForXML();
        this.activatePanel();
        Assert.assertEquals((long)1L, (long)this.countItems());
        Assert.assertNotNull((Object)this.getSecurityNamedServiceConfig("default"));
        Assert.assertNull((Object)this.getSecurityNamedServiceConfig("xxxxxxxx"));
        this.clickAddNew();
        tester.assertRenderedPage(SecurityNamedServiceNewPage.class);
        this.setSecurityConfigClassName(URLMasterPasswordProviderPanelInfo.class);
        this.newFormTester();
        this.setSecurityConfigName("default2");
        this.clickCancel();
        tester.assertRenderedPage(this.basePage.getClass());
        Assert.assertEquals((long)1L, (long)this.countItems());
        Assert.assertNotNull((Object)this.getSecurityNamedServiceConfig("default"));
        Assert.assertNull((Object)this.getSecurityNamedServiceConfig("default2"));
        this.clickAddNew();
        this.setSecurityConfigClassName(URLMasterPasswordProviderPanelInfo.class);
        this.newFormTester();
        this.setSecurityConfigName("default2");
        this.formTester.setValue("panel:content:uRL", "file:passwd");
        this.clickSave();
        tester.assertRenderedPage(this.basePage.getClass());
        Assert.assertEquals((long)2L, (long)this.countItems());
        Assert.assertNotNull((Object)this.getSecurityNamedServiceConfig("default"));
        Assert.assertNotNull((Object)this.getSecurityNamedServiceConfig("default2"));
        this.clickAddNew();
        this.setSecurityConfigClassName(URLMasterPasswordProviderPanelInfo.class);
        this.newFormTester();
        this.setSecurityConfigName("default2");
        this.formTester.setValue("panel:content:uRL", "file:passwd");
        this.clickSave();
        tester.assertRenderedPage(SecurityNamedServiceNewPage.class);
        this.testErrorMessagesWithRegExp(".*default2.*");
        this.clickCancel();
        tester.assertRenderedPage(this.basePage.getClass());
        this.clickNamedServiceConfig("default2");
        tester.assertRenderedPage(SecurityNamedServiceEditPage.class);
        tester.debugComponentTrees();
        this.newFormTester("panel:panel:form");
        this.formTester.setValue("panel:uRL", "file:passwd2");
        this.clickCancel();
        tester.assertRenderedPage(this.basePage.getClass());
        URLMasterPasswordProviderConfig config = (URLMasterPasswordProviderConfig)this.getSecurityNamedServiceConfig("default2");
        Assert.assertEquals((Object)new URL("file:passwd"), (Object)config.getURL());
        this.clickNamedServiceConfig("default2");
        this.newFormTester("panel:panel:form");
        this.formTester.setValue("panel:uRL", "file:passwd2");
        this.clickSave();
        tester.assertRenderedPage(this.basePage.getClass());
        config = (URLMasterPasswordProviderConfig)this.getSecurityNamedServiceConfig("default2");
        Assert.assertEquals((Object)new URL("file:passwd2"), (Object)config.getURL());
    }

    @Test
    public void testRemove() throws Exception {
        this.initializeForXML();
        URLMasterPasswordProviderConfig config = new URLMasterPasswordProviderConfig();
        config.setName("default2");
        config.setClassName(URLMasterPasswordProvider.class.getCanonicalName());
        config.setURL(new URL("file:passwd"));
        this.getSecurityManager().saveMasterPasswordProviderConfig((MasterPasswordProviderConfig)config);
        this.activatePanel();
        Assert.assertEquals((long)2L, (long)this.countItems());
        this.doRemove(null, "default2");
        Assert.assertNull((Object)this.getSecurityManager().loadMasterPassswordProviderConfig("default2"));
        Assert.assertEquals((long)1L, (long)this.countItems());
    }
}

