/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.role;

import org.apache.wicket.Component;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.config.SecurityRoleServiceConfig;
import org.geoserver.security.web.AbstractSecurityNamedServicePanelTest;
import org.geoserver.security.web.AbstractSecurityPage;
import org.geoserver.security.web.SecurityNamedServiceEditPage;
import org.geoserver.security.web.SecurityNamedServiceNewPage;
import org.geoserver.security.web.UserGroupRoleServicesPage;
import org.geoserver.security.web.role.RoleServicesPanel;
import org.geoserver.security.web.role.XMLRoleServicePanelInfo;
import org.geoserver.security.xml.XMLRoleService;
import org.geoserver.security.xml.XMLRoleServiceConfig;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class XMLRoleConfigDetailsPanelTest
extends AbstractSecurityNamedServicePanelTest {
    @Override
    protected String getDetailsFormComponentId() {
        return "RoleTabbedPage:panel:namedConfig";
    }

    @Override
    protected AbstractSecurityPage getBasePage() {
        return new UserGroupRoleServicesPage();
    }

    @Override
    protected String getBasePanelId() {
        return "panel:panel:roleServices";
    }

    @Override
    protected Integer getTabIndex() {
        return 1;
    }

    @Override
    protected Class<? extends Component> getNamedServicesClass() {
        return RoleServicesPanel.class;
    }

    protected void setAdminRoleName(String roleName) {
        this.formTester.setValue("panel:content:adminRoleName", roleName);
    }

    protected String getAdminRoleName() {
        return this.formTester.getForm().get("details:config.adminRoleName").getDefaultModelObjectAsString();
    }

    protected void setFileName(String fileName) {
        this.formTester.setValue("panel:content:fileName", fileName);
    }

    protected String getFileName() {
        return this.formTester.getForm().get("details:config.fileName").getDefaultModelObjectAsString();
    }

    protected void setCheckInterval(Integer interval) {
        this.formTester.setValue("panel:content:checkInterval", interval.toString());
    }

    protected Integer getCheckInterval() {
        String temp = this.formTester.getForm().get("details:config.checkInterval").getDefaultModelObjectAsString();
        if (temp == null || temp.length() == 0) {
            return 0;
        }
        return new Integer(temp);
    }

    protected void setValidating(Boolean flag) {
        this.formTester.setValue("panel:content:validating", flag.booleanValue());
    }

    protected Boolean getValidating() {
        String temp = this.formTester.getForm().get("details:config.validating").getDefaultModelObjectAsString();
        return Boolean.valueOf(temp);
    }

    @Before
    public void removeRoleService2() throws Exception {
        GeoServerSecurityManager secMgr = this.getSecurityManager();
        if (secMgr.listRoleServices().contains("default2")) {
            SecurityRoleServiceConfig roleService = secMgr.loadRoleServiceConfig("default2");
            secMgr.removeRoleService(roleService);
        }
    }

    @Test
    public void testAddModifyRemove() throws Exception {
        this.initializeForXML();
        this.activatePanel();
        Assert.assertEquals((long)2L, (long)this.countItems());
        Assert.assertNotNull((Object)this.getSecurityNamedServiceConfig("default"));
        Assert.assertNotNull((Object)this.getSecurityNamedServiceConfig("test"));
        Assert.assertNull((Object)this.getSecurityNamedServiceConfig("xxxxxxxx"));
        this.clickAddNew();
        tester.assertRenderedPage(SecurityNamedServiceNewPage.class);
        this.newFormTester();
        this.setSecurityConfigClassName(XMLRoleServicePanelInfo.class);
        this.newFormTester();
        this.setSecurityConfigName("default2");
        this.setFileName("abc.xml");
        this.setCheckInterval(5000);
        this.setValidating(true);
        this.clickCancel();
        tester.assertRenderedPage(this.basePage.getClass());
        Assert.assertEquals((long)2L, (long)this.countItems());
        Assert.assertNotNull((Object)this.getSecurityNamedServiceConfig("default"));
        this.clickAddNew();
        this.newFormTester();
        this.setSecurityConfigClassName(XMLRoleServicePanelInfo.class);
        this.newFormTester();
        this.setSecurityConfigName("default2");
        this.setFileName("abc.xml");
        this.setCheckInterval(5000);
        this.setValidating(true);
        tester.assertRenderedPage(SecurityNamedServiceNewPage.class);
        this.clickSave();
        tester.assertRenderedPage(this.basePage.getClass());
        Assert.assertEquals((long)3L, (long)this.countItems());
        Assert.assertNotNull((Object)this.getSecurityNamedServiceConfig("default"));
        XMLRoleServiceConfig xmlConfig = (XMLRoleServiceConfig)this.getSecurityNamedServiceConfig("default2");
        Assert.assertNotNull((Object)xmlConfig);
        Assert.assertEquals((Object)"default2", (Object)xmlConfig.getName());
        Assert.assertEquals((Object)XMLRoleService.class.getName(), (Object)xmlConfig.getClassName());
        Assert.assertNull((Object)xmlConfig.getAdminRoleName());
        Assert.assertEquals((Object)"abc.xml", (Object)xmlConfig.getFileName());
        Assert.assertEquals((long)5000L, (long)xmlConfig.getCheckInterval());
        Assert.assertEquals((Object)true, (Object)xmlConfig.isValidating());
        xmlConfig = (XMLRoleServiceConfig)this.getSecurityManager().loadRoleServiceConfig("default2");
        Assert.assertNotNull((Object)xmlConfig);
        Assert.assertEquals((Object)"default2", (Object)xmlConfig.getName());
        Assert.assertEquals((Object)XMLRoleService.class.getName(), (Object)xmlConfig.getClassName());
        Assert.assertNull((Object)xmlConfig.getAdminRoleName());
        Assert.assertEquals((Object)"abc.xml", (Object)xmlConfig.getFileName());
        Assert.assertEquals((long)5000L, (long)xmlConfig.getCheckInterval());
        Assert.assertEquals((Object)true, (Object)xmlConfig.isValidating());
        this.clickAddNew();
        this.newFormTester();
        this.setSecurityConfigClassName(XMLRoleServicePanelInfo.class);
        this.newFormTester();
        this.setSecurityConfigName("default2");
        this.clickSave();
        tester.assertRenderedPage(SecurityNamedServiceNewPage.class);
        this.testErrorMessagesWithRegExp(".*default2.*");
        this.clickCancel();
        tester.assertRenderedPage(this.basePage.getClass());
        this.clickNamedServiceConfig("default");
        tester.assertRenderedPage(SecurityNamedServiceEditPage.class);
        this.newFormTester("panel:panel:panel:form");
        tester.debugComponentTrees();
        this.formTester.setValue("panel:adminRoleName", "ROLE_ADMINISTRATOR");
        this.formTester.setValue("panel:checkInterval", "5001");
        this.formTester.setValue("panel:validating", true);
        this.clickCancel();
        tester.assertRenderedPage(this.basePage.getClass());
        xmlConfig = (XMLRoleServiceConfig)this.getSecurityNamedServiceConfig("default");
        Assert.assertEquals((Object)XMLRoleService.DEFAULT_LOCAL_ADMIN_ROLE, (Object)xmlConfig.getAdminRoleName());
        Assert.assertEquals((Object)XMLRoleService.DEFAULT_LOCAL_GROUP_ADMIN_ROLE, (Object)xmlConfig.getGroupAdminRoleName());
        Assert.assertEquals((Object)"roles.xml", (Object)xmlConfig.getFileName());
        Assert.assertEquals((long)10000L, (long)xmlConfig.getCheckInterval());
        Assert.assertEquals((Object)true, (Object)xmlConfig.isValidating());
        this.clickNamedServiceConfig("default2");
        this.newFormTester("panel:panel:panel:form");
        this.formTester.setValue("panel:adminRoleName", null);
        this.formTester.setValue("panel:checkInterval", "5001");
        this.formTester.setValue("panel:validating", false);
        this.clickSave();
        tester.assertRenderedPage(this.basePage.getClass());
        xmlConfig = (XMLRoleServiceConfig)this.getSecurityNamedServiceConfig("default2");
        Assert.assertNull((Object)xmlConfig.getAdminRoleName());
        Assert.assertEquals((Object)"abc.xml", (Object)xmlConfig.getFileName());
        Assert.assertEquals((long)5001L, (long)xmlConfig.getCheckInterval());
        Assert.assertEquals((Object)false, (Object)xmlConfig.isValidating());
        xmlConfig = (XMLRoleServiceConfig)this.getSecurityManager().loadRoleServiceConfig("default2");
        Assert.assertNull((Object)xmlConfig.getAdminRoleName());
        Assert.assertEquals((Object)"abc.xml", (Object)xmlConfig.getFileName());
        Assert.assertEquals((long)5001L, (long)xmlConfig.getCheckInterval());
        Assert.assertEquals((Object)false, (Object)xmlConfig.isValidating());
    }

    @Test
    public void testRemove() throws Exception {
        this.initializeForXML();
        XMLRoleServiceConfig config = new XMLRoleServiceConfig();
        config.setName("default2");
        config.setClassName(XMLRoleService.class.getCanonicalName());
        config.setFileName("foo.xml");
        this.getSecurityManager().saveRoleService((SecurityRoleServiceConfig)config);
        this.activatePanel();
        this.doRemove(null, "default2");
        Assert.assertNull((Object)this.getSecurityManager().loadRoleService("default2"));
    }
}

