/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.service;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.wicket.Page;
import org.apache.wicket.extensions.markup.html.form.palette.component.Recorder;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.security.impl.ServiceAccessRule;
import org.geoserver.security.impl.ServiceAccessRuleDAO;
import org.geoserver.security.web.AbstractSecurityWicketTestSupport;
import org.geoserver.security.web.role.NewRolePage;
import org.geoserver.security.web.service.NewServiceAccessRulePage;
import org.geoserver.security.web.service.ServiceAccessRulePage;
import org.junit.Assert;
import org.junit.Test;

public class NewServiceAccessRulePageTest
extends AbstractSecurityWicketTestSupport {
    NewServiceAccessRulePage page;

    @Test
    public void testFill() throws Exception {
        this.initializeForXML();
        this.page = new NewServiceAccessRulePage();
        tester.startPage((Page)this.page);
        tester.assertRenderedPage(NewServiceAccessRulePage.class);
        FormTester form = tester.newFormTester("form");
        int index = this.indexOf(this.page.serviceChoice.getChoices(), "wfs");
        form.select("service", index);
        tester.executeAjaxEvent("form:service", "change");
        form = tester.newFormTester("form");
        index = this.indexOf(this.page.methodChoice.getChoices(), "GetFeatureWithLock");
        form.select("method", index);
        tester.assertComponent("form:roles:palette:recorder", Recorder.class);
        form.submit("roles:addRole");
        tester.assertRenderedPage(NewRolePage.class);
        form = tester.newFormTester("form");
        form.setValue("name", "ROLE_NEW");
        form.submit("save");
        form = tester.newFormTester("form");
        tester.assertRenderedPage(NewServiceAccessRulePage.class);
        form.setValue("roles:palette:recorder", this.gaService.getRoleByName("ROLE_NEW").getAuthority());
        form.submit("roles:addRole");
        tester.assertRenderedPage(NewRolePage.class);
        tester.clickLink("form:cancel");
        tester.assertRenderedPage(NewServiceAccessRulePage.class);
        form = tester.newFormTester("form");
        form.submit("save");
        tester.assertErrorMessages((Serializable[])new String[0]);
        tester.assertRenderedPage(ServiceAccessRulePage.class);
        ServiceAccessRule foundRule = null;
        for (ServiceAccessRule rule : ServiceAccessRuleDAO.get().getRules()) {
            if (!"wfs".equals(rule.getService()) || !"GetFeatureWithLock".equals(rule.getMethod())) continue;
            foundRule = rule;
            break;
        }
        Assert.assertNotNull(foundRule);
        Assert.assertEquals((long)1L, (long)foundRule.getRoles().size());
        Assert.assertEquals((Object)"ROLE_NEW", foundRule.getRoles().iterator().next());
    }

    @Test
    public void testListWfsOperations() throws Exception {
        this.initializeForXML();
        this.page = new NewServiceAccessRulePage();
        tester.startPage((Page)this.page);
        tester.assertRenderedPage(NewServiceAccessRulePage.class);
        FormTester form = tester.newFormTester("form");
        int index = this.indexOf(this.page.serviceChoice.getChoices(), "wfs");
        form.select("service", index);
        tester.executeAjaxEvent("form:service", "change");
        List wfsOperations = this.page.methodChoice.getChoices();
        List<String> expectedWfsOperations = Arrays.asList("*", "GetCapabilities", "DescribeFeatureType", "GetFeature", "LockFeature", "Transaction", "GetGmlObject", "DropStoredQuery", "CreateStoredQuery", "GetFeatureWithLock", "DescribeStoredQueries", "GetPropertyValue", "ListStoredQueries");
        Assert.assertEquals((long)expectedWfsOperations.size(), (long)wfsOperations.size());
        Assert.assertTrue((boolean)wfsOperations.containsAll(expectedWfsOperations));
    }

    @Test
    public void testDuplicateRule() throws Exception {
        this.initializeForXML();
        this.initializeServiceRules();
        this.page = new NewServiceAccessRulePage();
        tester.startPage((Page)this.page);
        FormTester form = tester.newFormTester("form");
        int index = this.indexOf(this.page.serviceChoice.getChoices(), "wfs");
        form.select("service", index);
        tester.executeAjaxEvent("form:service", "change");
        form = tester.newFormTester("form");
        index = this.indexOf(this.page.methodChoice.getChoices(), "GetFeature");
        form.select("method", index);
        form.setValue("roles:palette:recorder", "ROLE_WFS");
        form.submit("save");
        Assert.assertTrue((boolean)this.testErrorMessagesWithRegExp(".*wfs\\.GetFeature.*"));
        tester.assertRenderedPage(NewServiceAccessRulePage.class);
    }

    @Test
    public void testEmptyRoles() throws Exception {
        this.initializeForXML();
        this.initializeServiceRules();
        this.page = new NewServiceAccessRulePage();
        tester.startPage((Page)this.page);
        FormTester form = tester.newFormTester("form");
        int index = this.indexOf(this.page.serviceChoice.getChoices(), "wfs");
        form.select("service", index);
        tester.executeAjaxEvent("form:service", "change");
        form = tester.newFormTester("form");
        index = this.indexOf(this.page.methodChoice.getChoices(), "GetFeature");
        form.select("method", index);
        form.submit("save");
        Assert.assertTrue((boolean)this.testErrorMessagesWithRegExp(".*has no role.*"));
        tester.assertRenderedPage(NewServiceAccessRulePage.class);
    }

    @Test
    public void testReadOnlyRoleService() throws Exception {
        this.initializeForXML();
        this.activateRORoleService();
        this.page = new NewServiceAccessRulePage();
        tester.startPage((Page)this.page);
        tester.assertInvisible("form:roles:addRole");
    }

    protected int indexOf(List<? extends String> strings, String searchValue) {
        int index = 0;
        for (String string : strings) {
            if (string.equals(searchValue)) {
                return index;
            }
            ++index;
        }
        Assert.assertTrue((index != -1 ? 1 : 0) != 0);
        return -1;
    }
}

