/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.auth;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.OnChangeAjaxBehavior;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.StringResourceModel;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.RequestFilterChain;
import org.geoserver.security.config.SecurityManagerConfig;
import org.geoserver.security.filter.GeoServerRoleFilter;
import org.geoserver.security.validation.SecurityConfigValidator;
import org.geoserver.security.web.AbstractSecurityPage;
import org.geoserver.security.web.auth.AuthenticationPage;
import org.geoserver.security.web.auth.RequestFilterChainWrapper;
import org.geoserver.web.wicket.GeoServerDialog;
import org.geoserver.web.wicket.HelpLink;
import org.geotools.util.logging.Logging;

public class SecurityFilterChainPage
extends AbstractSecurityPage {
    private static final long serialVersionUID = 1L;
    protected static Logger LOGGER = Logging.getLogger((String)"org.geoserver.web.security");
    protected RequestFilterChainWrapper chainWrapper;
    SecurityManagerConfig secMgrConfig;
    protected GeoServerDialog dialog;
    Form<? extends RequestFilterChainWrapper> form;
    CheckBox[] methodList = new CheckBox[7];
    protected boolean isNew;

    public SecurityFilterChainPage(RequestFilterChain chain, SecurityManagerConfig secMgrConfig, boolean isNew) {
        RequestFilterChainWrapper wrapper = new RequestFilterChainWrapper(chain);
        Form theForm = new Form("form", (IModel)new CompoundPropertyModel((Object)wrapper));
        this.initialize(chain, secMgrConfig, isNew, (Form<? extends RequestFilterChainWrapper>)theForm, wrapper);
    }

    protected SecurityFilterChainPage() {
    }

    protected void initialize(RequestFilterChain chain, SecurityManagerConfig secMgrConfig, boolean isNew, Form<? extends RequestFilterChainWrapper> theForm, RequestFilterChainWrapper wrapper) {
        this.chainWrapper = wrapper;
        this.isNew = isNew;
        this.secMgrConfig = secMgrConfig;
        this.form = theForm;
        this.add(new Component[]{this.form});
        boolean isAdmin = this.getSecurityManager().checkAuthenticationForAdminRole();
        this.setEnabled(isAdmin);
        this.form.add(new Component[]{new Label("message", (IModel)(isAdmin ? new Model() : new StringResourceModel("notAdmin", (Component)this, null)))});
        if (!isAdmin) {
            this.form.get("message").add(new Behavior[]{new AttributeAppender("class", (IModel)new Model((Serializable)((Object)"info-link")), " ")});
        }
        this.setOutputMarkupId(true);
        this.form.add(new Component[]{new TextField("name").setEnabled(isNew)});
        this.form.add(new Component[]{new TextField("patternString")});
        this.form.add(new Component[]{new CheckBox("disabled")});
        this.form.add(new Component[]{new CheckBox("allowSessionCreation")});
        this.form.add(new Component[]{new CheckBox("requireSSL")});
        this.form.add(new Component[]{new CheckBox("matchHTTPMethod").add(new Behavior[]{new OnChangeAjaxBehavior(){

            protected void onUpdate(AjaxRequestTarget target) {
                for (CheckBox cb : SecurityFilterChainPage.this.methodList) {
                    cb.setEnabled(SecurityFilterChainPage.this.chainWrapper.isMatchHTTPMethod());
                    target.add(new Component[]{cb});
                }
            }
        }})});
        ArrayList<String> filterNames = new ArrayList<String>();
        try {
            filterNames.addAll(this.getSecurityManager().listFilters(GeoServerRoleFilter.class));
            for (GeoServerRoleFilter filter : GeoServerExtensions.extensions(GeoServerRoleFilter.class)) {
                filterNames.add(filter.getName());
            }
            this.form.add(new Component[]{new DropDownChoice("roleFilterName", (IModel)new PropertyModel((Object)this.chainWrapper.getChain(), "roleFilterName"), filterNames).setNullValid(true)});
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Component[] componentArray = new Component[1];
        this.methodList[0] = new CheckBox("GET");
        componentArray[0] = this.methodList[0];
        this.form.add(componentArray);
        Component[] componentArray2 = new Component[1];
        this.methodList[1] = new CheckBox("POST");
        componentArray2[0] = this.methodList[1];
        this.form.add(componentArray2);
        Component[] componentArray3 = new Component[1];
        this.methodList[2] = new CheckBox("PUT");
        componentArray3[0] = this.methodList[2];
        this.form.add(componentArray3);
        Component[] componentArray4 = new Component[1];
        this.methodList[3] = new CheckBox("DELETE");
        componentArray4[0] = this.methodList[3];
        this.form.add(componentArray4);
        Component[] componentArray5 = new Component[1];
        this.methodList[4] = new CheckBox("OPTIONS");
        componentArray5[0] = this.methodList[4];
        this.form.add(componentArray5);
        Component[] componentArray6 = new Component[1];
        this.methodList[5] = new CheckBox("HEAD");
        componentArray6[0] = this.methodList[5];
        this.form.add(componentArray6);
        Component[] componentArray7 = new Component[1];
        this.methodList[6] = new CheckBox("TRACE");
        componentArray7[0] = this.methodList[6];
        this.form.add(componentArray7);
        for (CheckBox cb : this.methodList) {
            cb.setOutputMarkupPlaceholderTag(true);
            cb.setEnabled(chain.isMatchHTTPMethod());
        }
        Component[] componentArray8 = new Component[1];
        this.dialog = new GeoServerDialog("dialog");
        componentArray8[0] = this.dialog;
        this.form.add(componentArray8);
        this.form.add(new Component[]{new HelpLink("chainConfigHelp").setDialog(this.dialog)});
        this.form.add(new Component[]{new HelpLink("chainConfigMethodHelp").setDialog(this.dialog)});
        this.form.add(new Component[]{new SubmitLink("close", this.form){

            public void onSubmit() {
                SecurityFilterChainPage.this.handleSubmit(this.getForm());
            }
        }});
        this.form.add(new Component[]{new Link("cancel"){

            public void onClick() {
                SecurityFilterChainPage.this.doReturn();
            }
        }});
    }

    protected void handleSubmit(Form<?> form) {
        RequestFilterChain chain = this.chainWrapper.getChain();
        try {
            new SecurityConfigValidator(this.getSecurityManager()).validateRequestFilterChain(this.chainWrapper.getChain());
            if (this.isNew) {
                this.secMgrConfig.getFilterChain().getRequestChains().add(chain);
            }
            this.doReturn();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error saving config", e);
            this.error(e);
        }
    }

    protected void doReturn() {
        ((AuthenticationPage)this.returnPage).updateChainComponents();
        super.doReturn();
    }

    protected boolean isNew() {
        return this.isNew;
    }
}

