/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.role;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.impl.RoleHierarchyHelper;
import org.geoserver.security.validation.AbstractSecurityException;
import org.geoserver.security.web.AbstractSecurityPage;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geoserver.web.wicket.property.PropertyEditorFormComponent;
import org.springframework.util.StringUtils;

public abstract class AbstractRolePage
extends AbstractSecurityPage {
    String roleServiceName;

    protected AbstractRolePage(String roleService, GeoServerRole role) {
        this.roleServiceName = roleService;
        boolean hasRoleStore = this.hasRoleStore(this.roleServiceName);
        if (role == null) {
            role = new GeoServerRole("");
        }
        Form form = new Form("form", (IModel)new CompoundPropertyModel((Object)role));
        this.add(new Component[]{form});
        StringResourceModel descriptionModel = role.getUserName() != null ? new StringResourceModel("personalizedRole", (Component)this.getPage()).setParameters(new Object[]{role.getUserName()}) : new StringResourceModel("anonymousRole", (Component)this.getPage());
        form.add(new Component[]{new Label("description", (IModel)descriptionModel)});
        form.add(new Component[]{new TextField("name", (IModel)new Model((Serializable)((Object)role.getAuthority()))).setRequired(true).setEnabled(hasRoleStore)});
        form.add(new Component[]{new DropDownChoice("parent", (IModel)new ParentRoleModel(role), (IModel)new ParentRolesModel(role)).setNullValid(true).setEnabled(hasRoleStore)});
        form.add(new Component[]{new PropertyEditorFormComponent("properties").setEnabled(hasRoleStore)});
        form.add(new Component[]{new SubmitLink("save"){

            public void onSubmit() {
                try {
                    AbstractRolePage.this.onFormSubmit((GeoServerRole)this.getForm().getModelObject());
                    AbstractRolePage.this.setReturnPageDirtyAndReturn(true);
                }
                catch (IOException e) {
                    if (e.getCause() instanceof AbstractSecurityException) {
                        this.error(e.getCause());
                    } else {
                        this.error((Serializable)new ParamResourceModel("saveError", (Component)this.getPage(), new Object[]{e.getMessage()}).getObject());
                    }
                    LOGGER.log(Level.SEVERE, "Error occurred while saving role", e);
                }
            }
        }.setVisible(hasRoleStore)});
        form.add(new Component[]{this.getCancelLink()});
    }

    protected abstract void onFormSubmit(GeoServerRole var1) throws IOException;

    class ParentRolesModel
    implements IModel<List<String>> {
        List<String> parentRoles;

        ParentRolesModel(GeoServerRole role) {
            try {
                this.parentRoles = this.computeAllowableParentRoles(role);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        List<String> computeAllowableParentRoles(GeoServerRole role) throws IOException {
            Map parentMappings = AbstractRolePage.this.getRoleService(AbstractRolePage.this.roleServiceName).getParentMappings();
            if (role != null && StringUtils.hasLength((String)role.getAuthority())) {
                RoleHierarchyHelper helper = new RoleHierarchyHelper(parentMappings);
                HashSet parents = new HashSet(parentMappings.keySet());
                parents.removeAll(helper.getDescendants(role.getAuthority()));
                parents.remove(role.getAuthority());
                return new ArrayList<String>(parents);
            }
            return new ArrayList<String>(parentMappings.keySet());
        }

        public List<String> getObject() {
            return this.parentRoles;
        }

        public void setObject(List<String> object) {
        }

        public void detach() {
        }
    }

    class ParentRoleModel
    extends LoadableDetachableModel<String> {
        GeoServerRole role;

        ParentRoleModel(GeoServerRole role) {
            this.role = role;
        }

        protected String load() {
            try {
                GeoServerRole parentRole = AbstractRolePage.this.getRoleService(AbstractRolePage.this.roleServiceName).getParentRole(this.role);
                return parentRole != null ? parentRole.getAuthority() : null;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

