/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.user;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.form.validation.AbstractFormValidator;
import org.apache.wicket.markup.html.form.validation.EqualInputValidator;
import org.apache.wicket.markup.html.form.validation.IFormValidator;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.request.component.IRequestablePage;
import org.geoserver.security.GeoServerRoleService;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.impl.GeoServerUser;
import org.geoserver.security.impl.GeoServerUserGroup;
import org.geoserver.security.impl.GroupAdminProperty;
import org.geoserver.security.impl.RoleCalculator;
import org.geoserver.security.password.GeoServerEmptyPasswordEncoder;
import org.geoserver.security.validation.AbstractSecurityException;
import org.geoserver.security.validation.PasswordPolicyException;
import org.geoserver.security.web.AbstractSecurityPage;
import org.geoserver.security.web.role.EditRolePage;
import org.geoserver.security.web.role.RoleListProvider;
import org.geoserver.security.web.role.RolePaletteFormComponent;
import org.geoserver.security.web.user.GroupsModel;
import org.geoserver.security.web.user.UserGroupListMultipleChoice;
import org.geoserver.security.web.user.UserGroupPaletteFormComponent;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geoserver.web.wicket.SimpleAjaxLink;
import org.geoserver.web.wicket.property.PropertyEditorFormComponent;

public abstract class AbstractUserPage
extends AbstractSecurityPage {
    protected RolePaletteFormComponent rolePalette;
    protected UserGroupPaletteFormComponent userGroupPalette;
    protected UserGroupListMultipleChoice adminGroupChoice;
    protected ListView<GeoServerRole> calculatedRoles;
    protected String ugServiceName;

    protected AbstractUserPage(String ugServiceName, final GeoServerUser user) {
        ArrayList roles;
        this.ugServiceName = ugServiceName;
        GeoServerUserGroupService ugService = this.getUserGroupService(ugServiceName);
        boolean emptyPasswd = this.getSecurityManager().loadPasswordEncoder(ugService.getPasswordEncoderName()) instanceof GeoServerEmptyPasswordEncoder;
        boolean hasUserGroupStore = ugService.canCreateStore();
        boolean hasRoleStore = this.hasRoleStore(this.getSecurityManager().getActiveRoleService().getName());
        Form form = new Form("form", (IModel)new CompoundPropertyModel((Object)user));
        this.add(new Component[]{form});
        form.add(new Component[]{new TextField("username").setEnabled(hasUserGroupStore)});
        form.add(new Component[]{new CheckBox("enabled").setEnabled(hasUserGroupStore)});
        PasswordTextField pw1 = new PasswordTextField("password"){

            public boolean isRequired() {
                return AbstractUserPage.this.isFinalSubmit((FormComponent)this);
            }
        };
        form.add(new Component[]{pw1});
        pw1.setResetPassword(false);
        pw1.setEnabled(hasUserGroupStore && !emptyPasswd);
        PasswordTextField pw2 = new PasswordTextField("confirmPassword", (IModel)new Model((Serializable)((Object)user.getPassword()))){

            public boolean isRequired() {
                return AbstractUserPage.this.isFinalSubmit((FormComponent)this);
            }
        };
        form.add(new Component[]{pw2});
        pw2.setResetPassword(false);
        pw2.setEnabled(hasUserGroupStore && !emptyPasswd);
        form.add(new Component[]{new PropertyEditorFormComponent("properties").setEnabled(hasUserGroupStore)});
        Component[] componentArray = new Component[1];
        this.userGroupPalette = new UserGroupPaletteFormComponent("groups", ugServiceName, user);
        componentArray[0] = this.userGroupPalette;
        form.add(componentArray);
        this.userGroupPalette.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change"){

            protected void onUpdate(AjaxRequestTarget target) {
                AbstractUserPage.this.updateCalculatedRoles(target);
            }
        }});
        this.userGroupPalette.setEnabled(hasUserGroupStore);
        try {
            roles = new ArrayList(this.getSecurityManager().getActiveRoleService().getRolesForUser(user.getUsername()));
        }
        catch (IOException e) {
            throw new WicketRuntimeException((Throwable)e);
        }
        Component[] componentArray2 = new Component[1];
        this.rolePalette = new RolePaletteFormComponent("roles", (IModel<List<GeoServerRole>>)new ListModel(roles));
        componentArray2[0] = this.rolePalette;
        form.add(componentArray2);
        this.rolePalette.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change"){

            protected void onUpdate(AjaxRequestTarget target) {
                AbstractUserPage.this.updateCalculatedRoles(target);
                AbstractUserPage.this.updateGroupAdminList(target);
            }
        }});
        this.rolePalette.setOutputMarkupId(true);
        this.rolePalette.setEnabled(hasRoleStore);
        boolean isGroupAdmin = roles.contains(GeoServerRole.GROUP_ADMIN_ROLE);
        ArrayList<GeoServerUserGroup> adminGroups = new ArrayList<GeoServerUserGroup>();
        if (isGroupAdmin) {
            for (String groupName : GroupAdminProperty.get((Properties)user.getProperties())) {
                try {
                    adminGroups.add(ugService.getGroupByGroupname(groupName));
                }
                catch (IOException e) {
                    throw new WicketRuntimeException((Throwable)e);
                }
            }
        }
        Component[] componentArray3 = new Component[1];
        this.adminGroupChoice = new UserGroupListMultipleChoice("adminGroups", (IModel<List<GeoServerUserGroup>>)new ListModel(adminGroups), (IModel<List<GeoServerUserGroup>>)new GroupsModel(ugServiceName));
        componentArray3[0] = this.adminGroupChoice;
        form.add(componentArray3);
        this.adminGroupChoice.setOutputMarkupId(true);
        this.adminGroupChoice.setEnabled(hasUserGroupStore && isGroupAdmin);
        WebMarkupContainer container = new WebMarkupContainer("calculatedRolesContainer");
        form.add(new Component[]{container});
        container.setOutputMarkupId(true);
        Component[] componentArray4 = new Component[1];
        this.calculatedRoles = new ListView<GeoServerRole>("calculatedRoles", (IModel)new CalculatedRoleModel(user)){

            protected void populateItem(ListItem<GeoServerRole> item) {
                IModel model = item.getModel();
                item.add(new Component[]{new SimpleAjaxLink("role", model, RoleListProvider.ROLENAME.getModel(model)){

                    protected void onClick(AjaxRequestTarget target) {
                        this.setResponsePage((IRequestablePage)new EditRolePage(AbstractUserPage.this.getSecurityManager().getActiveRoleService().getName(), (GeoServerRole)this.getDefaultModelObject()).setReturnPage(this.getPage()));
                    }
                }});
            }
        };
        componentArray4[0] = this.calculatedRoles;
        container.add(componentArray4);
        this.calculatedRoles.setOutputMarkupId(true);
        form.add(new Component[]{new SubmitLink("save"){

            public void onSubmit() {
                try {
                    if (AbstractUserPage.this.adminGroupChoice.isEnabled()) {
                        Collection groups = (Collection)AbstractUserPage.this.adminGroupChoice.getModelObject();
                        String[] groupNames = new String[groups.size()];
                        int i = 0;
                        for (GeoServerUserGroup group : groups) {
                            groupNames[i++] = group.getGroupname();
                        }
                        GroupAdminProperty.set((Properties)user.getProperties(), (String[])groupNames);
                    } else {
                        GroupAdminProperty.del((Properties)user.getProperties());
                    }
                    AbstractUserPage.this.onFormSubmit(user);
                    AbstractUserPage.this.setReturnPageDirtyAndReturn(true);
                }
                catch (Exception e) {
                    AbstractUserPage.this.handleSubmitError(e);
                }
            }
        }.setEnabled(hasUserGroupStore || this.hasRoleStore(this.getSecurityManager().getActiveRoleService().getName()))});
        form.add(new Component[]{this.getCancelLink()});
        form.add((IFormValidator)new EqualInputValidator((FormComponent)pw1, (FormComponent)pw2){
            private static final long serialVersionUID = 1L;

            public void validate(Form<?> form) {
                if (AbstractUserPage.this.isFinalSubmit(form)) {
                    super.validate(form);
                }
            }

            protected String resourceKey() {
                return "AbstractUserPage.passwordMismatch";
            }
        });
        form.add((IFormValidator)new GroupAdminValidator());
    }

    boolean isFinalSubmit(FormComponent component) {
        return this.isFinalSubmit(Form.findForm((Component)component));
    }

    boolean isFinalSubmit(Form form) {
        if (form == null) {
            return false;
        }
        return form.findSubmittingButton() == form.get("save");
    }

    void updateCalculatedRoles(AjaxRequestTarget target) {
        this.calculatedRoles.modelChanged();
        target.add(new Component[]{this.calculatedRoles.getParent()});
    }

    void updateGroupAdminList(AjaxRequestTarget target) {
        this.adminGroupChoice.setEnabled(this.rolePalette.getSelectedRoles().contains(GeoServerRole.GROUP_ADMIN_ROLE));
        target.add(new Component[]{this.adminGroupChoice});
    }

    void handleSubmitError(Exception e) {
        LOGGER.log(Level.SEVERE, "Error occurred while saving user", e);
        if (e instanceof RuntimeException && e.getCause() instanceof Exception) {
            e = (Exception)e.getCause();
        }
        if (e instanceof IOException && e.getCause() instanceof AbstractSecurityException) {
            e = (Exception)e.getCause();
        }
        if (e instanceof AbstractSecurityException) {
            this.error(e);
        } else {
            this.error((Serializable)new ParamResourceModel("saveError", (Component)this.getPage(), new Object[]{e.getMessage()}).getObject());
        }
    }

    protected abstract void onFormSubmit(GeoServerUser var1) throws IOException, PasswordPolicyException;

    class GroupAdminValidator
    extends AbstractFormValidator {
        GroupAdminValidator() {
        }

        public FormComponent<?>[] getDependentFormComponents() {
            return new FormComponent[]{AbstractUserPage.this.adminGroupChoice};
        }

        public void validate(Form<?> form) {
            if (AbstractUserPage.this.adminGroupChoice.isEnabled()) {
                AbstractUserPage.this.adminGroupChoice.updateModel();
                if (((Collection)AbstractUserPage.this.adminGroupChoice.getModelObject()).isEmpty()) {
                    form.error((Serializable)((Object)new StringResourceModel("noAdminGroups", (Component)AbstractUserPage.this.getPage(), null).getString()));
                }
            }
        }
    }

    class CalculatedRoleModel
    extends LoadableDetachableModel<List<GeoServerRole>> {
        GeoServerUser user;

        CalculatedRoleModel(GeoServerUser user) {
            this.user = user;
        }

        protected List<GeoServerRole> load() {
            ArrayList<GeoServerRole> tmp = new ArrayList<GeoServerRole>();
            ArrayList<GeoServerRole> result = new ArrayList<GeoServerRole>();
            try {
                GeoServerUserGroupService ugService = AbstractUserPage.this.getSecurityManager().loadUserGroupService(AbstractUserPage.this.ugServiceName);
                GeoServerRoleService gaService = AbstractUserPage.this.getSecurityManager().getActiveRoleService();
                RoleCalculator calc = new RoleCalculator(ugService, gaService);
                tmp.addAll(AbstractUserPage.this.rolePalette.getSelectedRoles());
                calc.addInheritedRoles(tmp);
                for (GeoServerUserGroup group : AbstractUserPage.this.userGroupPalette.getSelectedGroups()) {
                    if (!group.isEnabled()) continue;
                    tmp.addAll(calc.calculateRoles(group));
                }
                result.addAll(calc.personalizeRoles(this.user, tmp));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            Collections.sort(result);
            return result;
        }
    }
}

