/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestHandler;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.web.AbstractSecurityPage;
import org.geoserver.security.web.AbstractSecurityWicketTestSupport;
import org.geoserver.security.web.SecurityNamedServicePanelInfo;
import org.geoserver.web.wicket.GeoServerDialog;
import org.junit.Assert;
import org.junit.Before;

public abstract class AbstractSecurityNamedServicePanelTest
extends AbstractSecurityWicketTestSupport {
    public static final String FIRST_COLUM_PATH = "itemProperties:0:component:link";
    public static final String CHECKBOX_PATH = "selectItemContainer:selectItem";
    protected AbstractSecurityPage basePage;
    protected String basePanelId;
    protected FormTester formTester;
    GeoServerSecurityManager manager;

    protected void newFormTester() {
        this.newFormTester("form");
    }

    protected void newFormTester(String path) {
        this.formTester = tester.newFormTester(path);
    }

    @Before
    public void init() throws Exception {
        this.manager = this.getSecurityManager();
    }

    protected abstract AbstractSecurityPage getBasePage();

    protected abstract String getBasePanelId();

    protected abstract Integer getTabIndex();

    protected abstract Class<? extends Component> getNamedServicesClass();

    protected abstract String getDetailsFormComponentId();

    protected void activatePanel() {
        this.basePage = this.getBasePage();
        this.basePanelId = this.getBasePanelId();
        tester.startPage((Page)this.basePage);
        tester.assertRenderedPage(this.basePage.getPageClass());
    }

    protected void clickAddNew() {
        tester.clickLink(this.basePanelId + ":add");
    }

    protected void clickRemove() {
        tester.clickLink(this.basePanelId + ":remove");
    }

    protected Component getRemoveLink() {
        Component result = tester.getLastRenderedPage().get("tabbedPanel:panel:removeSelected");
        Assert.assertNotNull((Object)result);
        return result;
    }

    protected DataView<SecurityNamedServiceConfig> getDataView() {
        return (DataView)this.basePage.get(this.basePanelId + ":table:listContainer:items");
    }

    protected long countItems() {
        tester.debugComponentTrees();
        return this.getDataView().getItemCount();
    }

    protected SecurityNamedServiceConfig getSecurityNamedServiceConfig(String name) {
        Iterator it = this.getDataView().getItems();
        while (it.hasNext()) {
            Item item = (Item)it.next();
            if (!name.equals(((SecurityNamedServiceConfig)item.getModelObject()).getName())) continue;
            return (SecurityNamedServiceConfig)item.getModelObject();
        }
        return null;
    }

    protected void clickNamedServiceConfig(String name) {
        Iterator it = this.getDataView().getItems();
        while (it.hasNext()) {
            Item item = (Item)it.next();
            if (!name.equals(((SecurityNamedServiceConfig)item.getModelObject()).getName())) continue;
            tester.clickLink(item.getPageRelativePath() + ":" + FIRST_COLUM_PATH);
        }
    }

    protected void checkNamedServiceConfig(String name) {
        Iterator it = this.getDataView().getItems();
        while (it.hasNext()) {
            Item item = (Item)it.next();
            if (!name.equals(((SecurityNamedServiceConfig)item.getModelObject()).getName())) continue;
            tester.executeAjaxEvent(item.getPageRelativePath() + ":" + CHECKBOX_PATH, "click");
        }
    }

    protected void doRemove(String pathForLink, String ... serviceNames) throws Exception {
        AbstractSecurityPage testPage = (AbstractSecurityPage)tester.getLastRenderedPage();
        if (serviceNames.length == 0) {
            String selectAllPath = this.basePanelId + ":table:listContainer:selectAllContainer:selectAll";
            tester.assertComponent(selectAllPath, CheckBox.class);
            FormComponent selectAllPathComponent = (FormComponent)tester.getComponentFromLastRenderedPage(selectAllPath);
            this.setFormComponentValue(selectAllPathComponent, "true");
            tester.executeAjaxEvent(selectAllPath, "click");
        } else {
            DataView dataview = (DataView)testPage.get(this.basePanelId + ":table:listContainer:items");
            List<String> nameList = Arrays.asList(serviceNames);
            Iterator it = this.getDataView().getItems();
            while (it.hasNext()) {
                Item item = (Item)it.next();
                if (!nameList.contains(((SecurityNamedServiceConfig)item.getModelObject()).getName())) continue;
                String checkBoxPath = item.getPageRelativePath() + ":" + CHECKBOX_PATH;
                tester.assertComponent(checkBoxPath, CheckBox.class);
                FormComponent checkBoxPathComponent = (FormComponent)tester.getComponentFromLastRenderedPage(checkBoxPath);
                this.setFormComponentValue(checkBoxPathComponent, "true");
                testPage.get(checkBoxPath).setDefaultModelObject((Object)true);
                tester.executeAjaxEvent(checkBoxPath, "click");
            }
        }
        tester.assertNoErrorMessage();
        tester.assertComponent(this.basePanelId + ":dialog:dialog", ModalWindow.class);
        ModalWindow w = (ModalWindow)testPage.get(this.basePanelId + ":dialog:dialog");
        Assert.assertFalse((boolean)w.isShown());
        tester.clickLink(this.basePanelId + ":remove", true);
        Assert.assertTrue((boolean)w.isShown());
        ((GeoServerDialog)w.getParent()).submit((AjaxRequestTarget)new AjaxRequestHandler(tester.getLastRenderedPage()));
    }

    protected void simulateDeleteSubmit() throws Exception {
    }

    protected void setSecurityConfigName(String aName) {
        this.formTester.setValue("panel:content:name", aName);
    }

    protected String getSecurityConfigName() {
        return this.formTester.getForm().get("config.name").getDefaultModelObjectAsString();
    }

    protected String getSecurityConfigClassName() {
        return this.formTester.getForm().get("config.className").getDefaultModelObjectAsString();
    }

    protected <T extends SecurityNamedServicePanelInfo> void setSecurityConfigClassName(Class<T> clazz) {
        AjaxLink link;
        ListView list = (ListView)tester.getLastRenderedPage().get("servicesContainer:services");
        int toClick = -1;
        for (int i = 0; i < list.getList().size(); ++i) {
            if (!clazz.isInstance(list.getList().get(i))) continue;
            toClick = i;
            break;
        }
        if ((link = (AjaxLink)((MarkupContainer)list.get(toClick)).get("link")).isEnabled()) {
            tester.executeAjaxEvent((Component)link, "click");
        }
    }

    protected void clickSave() {
        this.formTester.submit("save");
    }

    protected void clickCancel() {
        this.formTester.submitLink("cancel", false);
    }
}

