/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.usergroup;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.OnChangeAjaxBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.tabs.AbstractTab;
import org.apache.wicket.extensions.markup.html.tabs.ITab;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.GeoServerUserGroupStore;
import org.geoserver.security.config.SecurityUserGroupServiceConfig;
import org.geoserver.security.impl.Util;
import org.geoserver.security.web.SecurityNamedServicePanel;
import org.geoserver.security.web.SecurityNamedServiceTabbedPanel;
import org.geoserver.security.web.group.GroupPanel;
import org.geoserver.security.web.passwd.PasswordEncoderChoice;
import org.geoserver.security.web.passwd.PasswordPolicyChoice;
import org.geoserver.security.web.user.UserPanel;

public class UserGroupServicePanel<T extends SecurityUserGroupServiceConfig>
extends SecurityNamedServicePanel<T>
implements SecurityNamedServiceTabbedPanel<T> {
    CheckBox recodeCheckBox = null;

    public UserGroupServicePanel(String id, IModel<T> model) {
        super(id, model);
        this.add(new Component[]{new PasswordEncoderChoice("passwordEncoderName").add(new Behavior[]{new OnChangeAjaxBehavior(){

            protected void onUpdate(AjaxRequestTarget target) {
                if (UserGroupServicePanel.this.recodeCheckBox.isVisible()) {
                    UserGroupServicePanel.this.recodeCheckBox.setEnabled(true);
                    target.add(new Component[]{UserGroupServicePanel.this.recodeCheckBox});
                }
            }
        }})});
        boolean canCreateStore = false;
        SecurityUserGroupServiceConfig config = (SecurityUserGroupServiceConfig)model.getObject();
        try {
            GeoServerUserGroupService s = (GeoServerUserGroupService)Class.forName(config.getClassName()).newInstance();
            canCreateStore = s.canCreateStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.recodeCheckBox = new CheckBox("recodeExistingPasswords", (IModel)Model.of((Serializable)Boolean.valueOf(false)));
        this.recodeCheckBox.setOutputMarkupId(true);
        this.recodeCheckBox.setVisible(canCreateStore);
        this.recodeCheckBox.setEnabled(false);
        this.add(new Component[]{this.recodeCheckBox});
        this.add(new Component[]{new PasswordPolicyChoice("passwordPolicyName")});
    }

    @Override
    public List<ITab> createTabs(final IModel<T> model) {
        ArrayList<ITab> tabs = new ArrayList<ITab>();
        tabs.add((ITab)new AbstractTab((IModel)new StringResourceModel("users", (Component)this, null)){

            public Panel getPanel(String panelId) {
                return new UserPanel(panelId, ((SecurityUserGroupServiceConfig)model.getObject()).getName());
            }
        });
        tabs.add((ITab)new AbstractTab((IModel)new StringResourceModel("groups", (Component)this, null)){

            public Panel getPanel(String panelId) {
                return new GroupPanel(panelId, ((SecurityUserGroupServiceConfig)model.getObject()).getName());
            }
        });
        return tabs;
    }

    @Override
    public void doSave(T config) throws Exception {
        GeoServerUserGroupService s;
        this.getSecurityManager().saveUserGroupService(config);
        if (((Boolean)this.recodeCheckBox.getModelObject()).booleanValue() && (s = this.getSecurityManager().loadUserGroupService(config.getName())).canCreateStore()) {
            Util.recodePasswords((GeoServerUserGroupStore)s.createStore());
        }
    }

    @Override
    public void doLoad(T config) throws Exception {
        this.getSecurityManager().loadUserGroupServiceConfig(config.getName());
    }
}

