/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public abstract class AbstractConfirmRemovalPanel<T>
extends Panel {
    private static final long serialVersionUID = 1L;
    List<T> roots;
    List<IModel<String>> problems;

    public AbstractConfirmRemovalPanel(String id, T ... roots) {
        this(id, (Model<?>)null, Arrays.asList(roots));
    }

    public AbstractConfirmRemovalPanel(String id, Model<?> model, T ... roots) {
        this(id, model, Arrays.asList(roots));
    }

    public AbstractConfirmRemovalPanel(String id, List<T> roots) {
        this(id, (Model<?>)null, roots);
    }

    public AbstractConfirmRemovalPanel(String id, Model<?> model, List<T> rootObjects) {
        super(id, model);
        this.setRootObjectsAndProblems(rootObjects);
        WebMarkupContainer root = new WebMarkupContainer("rootObjects");
        this.add(new Component[]{root});
        WebMarkupContainer removed = new WebMarkupContainer("removedObjects");
        this.add(new Component[]{removed});
        WebMarkupContainer rulesRemoved = new WebMarkupContainer("rulesRemoved");
        removed.add(new Component[]{rulesRemoved});
        if (this.roots.size() == 0) {
            removed.setVisible(false);
        } else {
            rulesRemoved.add(new Component[]{new ListView<String>("rules", this.names(this.roots)){

                protected void populateItem(ListItem<String> item) {
                    item.add(new Component[]{new Label("name", (Serializable)item.getModelObject())});
                }
            }});
        }
        WebMarkupContainer problematic = new WebMarkupContainer("problematicObjects");
        this.add(new Component[]{problematic});
        WebMarkupContainer rulesNotRemoved = new WebMarkupContainer("rulesNotRemoved");
        problematic.add(new Component[]{rulesNotRemoved});
        if (this.problems.size() == 0) {
            problematic.setVisible(false);
        } else {
            rulesNotRemoved.add(new Component[]{new ListView<String>("problems", this.problems(this.problems)){

                protected void populateItem(ListItem<String> item) {
                    item.add(new Component[]{new Label("name", (Serializable)item.getModelObject())});
                }
            }});
        }
    }

    void setRootObjectsAndProblems(List<T> rootObjects) {
        this.roots = new ArrayList<T>();
        this.problems = new ArrayList<IModel<String>>();
        for (T obj : rootObjects) {
            IModel<String> model = this.canRemove(obj);
            if (model == null) {
                this.roots.add(obj);
                continue;
            }
            this.problems.add(model);
        }
    }

    List<String> problems(List<IModel<String>> objects) {
        ArrayList<String> l = new ArrayList<String>();
        for (IModel<String> m : objects) {
            l.add((String)m.getObject());
        }
        return l;
    }

    List<String> names(List<T> objects) {
        ArrayList<String> l = new ArrayList<String>();
        for (T obj : objects) {
            l.add(this.name(obj));
        }
        return l;
    }

    String name(T object) {
        try {
            return this.getConfirmationMessage(object);
        }
        catch (IOException ioEx) {
            throw new RuntimeException(ioEx);
        }
        catch (Exception e) {
            throw new RuntimeException("A data object that does not have a 'name' property has been used, this is unexpected", e);
        }
    }

    protected IModel<String> canRemove(T data) {
        return null;
    }

    protected abstract String getConfirmationMessage(T var1) throws Exception;

    public List<T> getRoots() {
        return this.roots;
    }
}

