/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.auth;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.RequestFilterChain;
import org.geoserver.security.VariableFilterChain;
import org.geoserver.security.config.SecurityManagerConfig;
import org.geoserver.security.filter.GeoServerExceptionTranslationFilter;
import org.geoserver.security.filter.GeoServerSecurityInterceptorFilter;
import org.geoserver.security.web.auth.AuthFilterChainPalette;
import org.geoserver.security.web.auth.RequestFilterChainWrapper;
import org.geoserver.security.web.auth.SecurityFilterChainPage;
import org.geoserver.security.web.auth.VariableFilterChainWrapper;
import org.geoserver.web.wicket.HelpLink;

public class SecurityVariableFilterChainPage
extends SecurityFilterChainPage {
    private static final long serialVersionUID = 1L;
    protected AuthFilterChainPalette palette;

    public SecurityVariableFilterChainPage(VariableFilterChain chain, SecurityManagerConfig secMgrConfig, boolean isNew) {
        VariableFilterChainWrapper wrapper = new VariableFilterChainWrapper(chain);
        Form theForm = new Form("form", (IModel)new CompoundPropertyModel((Object)wrapper));
        super.initialize((RequestFilterChain)chain, secMgrConfig, isNew, (Form<? extends RequestFilterChainWrapper>)theForm, wrapper);
        ArrayList<String> filterNames = new ArrayList<String>();
        try {
            filterNames.addAll(this.getSecurityManager().listFilters(GeoServerExceptionTranslationFilter.class));
            for (GeoServerExceptionTranslationFilter filter : GeoServerExtensions.extensions(GeoServerExceptionTranslationFilter.class)) {
                filterNames.add(filter.getName());
            }
            this.form.add(new Component[]{new DropDownChoice("exceptionTranslationName", (IModel)new PropertyModel((Object)this.chainWrapper.getChain(), "exceptionTranslationName"), filterNames)});
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        filterNames = new ArrayList();
        try {
            filterNames.addAll(this.getSecurityManager().listFilters(GeoServerSecurityInterceptorFilter.class));
            for (GeoServerExceptionTranslationFilter filter : GeoServerExtensions.extensions(GeoServerSecurityInterceptorFilter.class)) {
                filterNames.add(filter.getName());
            }
            this.form.add(new Component[]{new DropDownChoice("interceptorName", (IModel)new PropertyModel((Object)this.chainWrapper.getChain(), "interceptorName"), filterNames)});
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Component[] componentArray = new Component[1];
        this.palette = new AuthFilterChainPalette("authFilterChain", new AuthFilterNamesModel(this.getVariableFilterChainWrapper()));
        componentArray[0] = this.palette;
        this.form.add(componentArray);
        this.palette.setOutputMarkupId(true);
        this.palette.setChain(this.getVariableFilterChainWrapper().getVariableFilterChain());
        this.form.add(new Component[]{new HelpLink("chainConfigFilterHelp").setDialog(this.dialog)});
    }

    VariableFilterChainWrapper getVariableFilterChainWrapper() {
        return (VariableFilterChainWrapper)this.chainWrapper;
    }

    class AuthFilterNamesModel
    implements IModel<List<String>> {
        private static final long serialVersionUID = 1L;
        VariableFilterChainWrapper chainModel;

        AuthFilterNamesModel(VariableFilterChainWrapper chainModel) {
            this.chainModel = chainModel;
        }

        public List<String> getObject() {
            GeoServerSecurityManager secMgr = SecurityVariableFilterChainPage.this.getSecurityManager();
            ArrayList<String> filters = new ArrayList<String>(this.chainModel.getChain().getFilterNames());
            try {
                filters.retainAll(this.chainModel.getVariableFilterChain().listFilterCandidates(secMgr));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return filters;
        }

        public void setObject(List<String> object) {
            this.chainModel.getChain().setFilterNames(object);
        }

        public void detach() {
        }
    }
}

