/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.user;

import java.lang.reflect.Method;
import java.util.SortedSet;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.geoserver.security.impl.GeoServerUser;
import org.geoserver.security.web.AbstractSecurityPage;
import org.geoserver.security.web.AbstractTabbedListPageTest;
import org.geoserver.security.web.user.EditUserPage;
import org.geoserver.security.web.user.NewUserPage;
import org.geoserver.security.web.user.SelectionUserRemovalLink;
import org.geoserver.security.web.user.UserListProvider;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.junit.Assert;
import org.junit.Test;

public class UserListPageTest
extends AbstractTabbedListPageTest<GeoServerUser> {
    protected boolean withRoles = false;

    protected AbstractSecurityPage listPage(String serviceName) {
        AbstractSecurityPage result = this.initializeForUGServiceNamed(serviceName);
        tester.clickLink(this.getTabbedPanelPath() + ":tabs-container:tabs:1:link", true);
        return result;
    }

    @Override
    protected Page newPage(AbstractSecurityPage page, Object ... params) {
        if (params.length == 0) {
            return new NewUserPage(this.getUserGroupServiceName()).setReturnPage((Page)page);
        }
        return new NewUserPage((String)params[0]).setReturnPage((Page)page);
    }

    @Override
    protected Page editPage(AbstractSecurityPage page, Object ... params) {
        if (params.length == 0) {
            return new EditUserPage(this.getUserGroupServiceName(), new GeoServerUser("dummyuser")).setReturnPage((Page)page);
        }
        if (params.length == 1) {
            return new EditUserPage(this.getUserGroupServiceName(), (GeoServerUser)params[0]).setReturnPage((Page)page);
        }
        return new EditUserPage((String)params[0], (GeoServerUser)params[1]).setReturnPage((Page)page);
    }

    @Override
    protected String getSearchString() throws Exception {
        GeoServerUser u = this.ugService.getUserByUsername("user1");
        Assert.assertNotNull((Object)u);
        return u.getUsername();
    }

    @Override
    protected GeoServerDataProvider.Property<GeoServerUser> getEditProperty() {
        return UserListProvider.USERNAME;
    }

    @Override
    protected boolean checkEditForm(String objectString) {
        return objectString.equals(tester.getComponentFromLastRenderedPage("form:username").getDefaultModelObject());
    }

    @Test
    public void testReadOnlyService() throws Exception {
        this.doInitialize();
        tester.startPage((Page)this.listPage(this.getUserGroupServiceName()));
        tester.assertVisible(this.getRemoveLink().getPageRelativePath());
        tester.assertVisible(this.getRemoveLinkWithRoles().getPageRelativePath());
        tester.assertVisible(this.getAddLink().getPageRelativePath());
        this.activateRORoleService();
        tester.startPage((Page)this.listPage(this.getUserGroupServiceName()));
        tester.assertVisible(this.getRemoveLink().getPageRelativePath());
        tester.assertInvisible(this.getRemoveLinkWithRoles().getPageRelativePath());
        tester.assertVisible(this.getAddLink().getPageRelativePath());
        this.activateROUGService();
        tester.startPage((Page)this.listPage(this.getROUserGroupServiceName()));
        tester.assertInvisible(this.getRemoveLink().getPageRelativePath());
        tester.assertInvisible(this.getAddLink().getPageRelativePath());
        tester.assertInvisible(this.getRemoveLinkWithRoles().getPageRelativePath());
    }

    @Override
    protected void simulateDeleteSubmit() throws Exception {
        SelectionUserRemovalLink link = (SelectionUserRemovalLink)(this.withRoles ? this.getRemoveLinkWithRoles() : this.getRemoveLink());
        Method m = link.delegate.getClass().getDeclaredMethod("onSubmit", AjaxRequestTarget.class, Component.class);
        m.invoke((Object)link.delegate, new Object[]{null, null});
        SortedSet users = this.ugService.getUsers();
        Assert.assertTrue((users.size() == 0 ? 1 : 0) != 0);
        if (this.withRoles) {
            Assert.assertTrue((this.gaService.getRolesForUser("user1").size() == 0 ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((this.gaService.getRolesForUser("user1").size() == 2 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testRemoveWithRoles() throws Exception {
        this.withRoles = true;
        this.addAdditonalData();
        this.doRemove(this.getTabbedPanelPath() + ":panel:header:removeSelectedWithRoles");
    }

    @Override
    protected String getTabbedPanelPath() {
        return "panel:panel";
    }

    @Override
    protected String getServiceName() {
        return this.getUserGroupServiceName();
    }
}

