/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.usergroup;

import org.apache.wicket.Component;
import org.geoserver.security.config.SecurityUserGroupServiceConfig;
import org.geoserver.security.web.AbstractSecurityNamedServicePanelTest;
import org.geoserver.security.web.AbstractSecurityPage;
import org.geoserver.security.web.SecurityNamedServiceEditPage;
import org.geoserver.security.web.SecurityNamedServiceNewPage;
import org.geoserver.security.web.UserGroupRoleServicesPage;
import org.geoserver.security.web.usergroup.UserGroupServicesPanel;
import org.geoserver.security.web.usergroup.XMLUserGroupServicePanelInfo;
import org.geoserver.security.xml.XMLUserGroupService;
import org.geoserver.security.xml.XMLUserGroupServiceConfig;
import org.junit.Assert;
import org.junit.Test;

public class XMLUserGroupConfigDetailsPanelTest
extends AbstractSecurityNamedServicePanelTest {
    @Override
    protected String getDetailsFormComponentId() {
        return "UserGroupTabbedPage:panel:namedConfig";
    }

    @Override
    protected AbstractSecurityPage getBasePage() {
        return new UserGroupRoleServicesPage();
    }

    @Override
    protected String getBasePanelId() {
        return "panel:panel:userGroupServices";
    }

    @Override
    protected Integer getTabIndex() {
        return 0;
    }

    @Override
    protected Class<? extends Component> getNamedServicesClass() {
        return UserGroupServicesPanel.class;
    }

    protected void setPasswordEncoderName(String encName) {
        this.formTester.setValue("panel:content:passwordEncoderName", encName);
    }

    protected String getPasswordEncoderName() {
        return this.formTester.getForm().get("details:config.passwordEncoderName").getDefaultModelObjectAsString();
    }

    protected void setPasswordPolicy(String policyName) {
        this.formTester.setValue("panel:content:passwordPolicyName", policyName);
    }

    protected String getPasswordPolicyName() {
        return this.formTester.getForm().get("details:config.passwordPolicyName").getDefaultModelObjectAsString();
    }

    protected void setFileName(String fileName) {
        this.formTester.setValue("panel:content:fileName", fileName);
    }

    protected String getFileName() {
        return this.formTester.getForm().get("details:config.fileName").getDefaultModelObjectAsString();
    }

    protected void setCheckInterval(Integer interval) {
        this.formTester.setValue("panel:content:checkInterval", interval.toString());
    }

    protected Integer getCheckInterval() {
        String temp = this.formTester.getForm().get("details:config.checkInterval").getDefaultModelObjectAsString();
        if (temp == null || temp.length() == 0) {
            return 0;
        }
        return new Integer(temp);
    }

    protected void setValidating(Boolean flag) {
        this.formTester.setValue("panel:content:validating", flag.booleanValue());
    }

    protected Boolean getValidating() {
        String temp = this.formTester.getForm().get("details:config.validating").getDefaultModelObjectAsString();
        return Boolean.valueOf(temp);
    }

    @Test
    public void testAddModify() throws Exception {
        this.initializeForXML();
        this.activatePanel();
        Assert.assertEquals((long)2L, (long)this.countItems());
        Assert.assertNotNull((Object)this.getSecurityNamedServiceConfig("default"));
        Assert.assertNotNull((Object)this.getSecurityNamedServiceConfig("test"));
        Assert.assertNull((Object)this.getSecurityNamedServiceConfig("xxxxxxxx"));
        this.clickAddNew();
        tester.assertRenderedPage(SecurityNamedServiceNewPage.class);
        this.setSecurityConfigClassName(XMLUserGroupServicePanelInfo.class);
        this.newFormTester();
        this.setSecurityConfigName("default2");
        this.setFileName("abc.xml");
        this.setCheckInterval(5000);
        this.setValidating(true);
        this.clickCancel();
        tester.assertRenderedPage(this.basePage.getClass());
        Assert.assertEquals((long)2L, (long)this.countItems());
        Assert.assertNotNull((Object)this.getSecurityNamedServiceConfig("default"));
        this.clickAddNew();
        tester.assertRenderedPage(SecurityNamedServiceNewPage.class);
        this.setSecurityConfigClassName(XMLUserGroupServicePanelInfo.class);
        this.newFormTester();
        this.setPasswordEncoderName(this.getDigestPasswordEncoder().getName());
        this.setPasswordPolicy("default");
        this.setSecurityConfigName("default2");
        this.setFileName("abc.xml");
        this.setCheckInterval(5000);
        this.setValidating(true);
        this.clickSave();
        tester.assertNoErrorMessage();
        tester.assertRenderedPage(this.basePage.getClass());
        Assert.assertEquals((long)3L, (long)this.countItems());
        Assert.assertNotNull((Object)this.getSecurityNamedServiceConfig("default"));
        XMLUserGroupServiceConfig xmlConfig = (XMLUserGroupServiceConfig)this.getSecurityNamedServiceConfig("default2");
        Assert.assertNotNull((Object)xmlConfig);
        Assert.assertEquals((Object)"default2", (Object)xmlConfig.getName());
        Assert.assertEquals((Object)XMLUserGroupService.class.getName(), (Object)xmlConfig.getClassName());
        Assert.assertEquals((Object)this.getDigestPasswordEncoder().getName(), (Object)xmlConfig.getPasswordEncoderName());
        Assert.assertEquals((Object)"default", (Object)xmlConfig.getPasswordPolicyName());
        Assert.assertEquals((Object)"abc.xml", (Object)xmlConfig.getFileName());
        Assert.assertEquals((long)5000L, (long)xmlConfig.getCheckInterval());
        Assert.assertEquals((Object)true, (Object)xmlConfig.isValidating());
        xmlConfig = (XMLUserGroupServiceConfig)this.getSecurityManager().loadUserGroupServiceConfig("default2");
        Assert.assertNotNull((Object)xmlConfig);
        Assert.assertEquals((Object)"default2", (Object)xmlConfig.getName());
        Assert.assertEquals((Object)this.getDigestPasswordEncoder().getName(), (Object)xmlConfig.getPasswordEncoderName());
        Assert.assertEquals((Object)"default", (Object)xmlConfig.getPasswordPolicyName());
        Assert.assertEquals((Object)"abc.xml", (Object)xmlConfig.getFileName());
        Assert.assertEquals((long)5000L, (long)xmlConfig.getCheckInterval());
        Assert.assertEquals((Object)true, (Object)xmlConfig.isValidating());
        this.clickAddNew();
        this.newFormTester();
        this.setSecurityConfigClassName(XMLUserGroupServicePanelInfo.class);
        this.newFormTester();
        this.setSecurityConfigName("default2");
        this.clickSave();
        tester.assertRenderedPage(SecurityNamedServiceNewPage.class);
        this.testErrorMessagesWithRegExp(".*default2.*");
        this.clickCancel();
        tester.assertRenderedPage(this.basePage.getClass());
        this.clickNamedServiceConfig("default");
        tester.assertRenderedPage(SecurityNamedServiceEditPage.class);
        this.newFormTester("panel:panel:panel:form");
        this.formTester.setValue("panel:passwordPolicyName", "master");
        this.formTester.setValue("panel:passwordEncoderName", this.getPlainTextPasswordEncoder().getName());
        Assert.assertEquals((Object)this.getDigestPasswordEncoder().getName(), (Object)xmlConfig.getPasswordEncoderName());
        Assert.assertEquals((Object)"default", (Object)xmlConfig.getPasswordPolicyName());
        this.formTester.setValue("panel:checkInterval", "5001");
        this.formTester.setValue("panel:validating", true);
        this.clickCancel();
        tester.assertRenderedPage(this.basePage.getClass());
        xmlConfig = (XMLUserGroupServiceConfig)this.getSecurityNamedServiceConfig("default");
        Assert.assertEquals((Object)this.getDigestPasswordEncoder().getName(), (Object)xmlConfig.getPasswordEncoderName());
        Assert.assertEquals((Object)"default", (Object)xmlConfig.getPasswordPolicyName());
        Assert.assertEquals((Object)"users.xml", (Object)xmlConfig.getFileName());
        Assert.assertEquals((long)10000L, (long)xmlConfig.getCheckInterval());
        Assert.assertEquals((Object)true, (Object)xmlConfig.isValidating());
        this.clickNamedServiceConfig("default2");
        this.newFormTester("panel:panel:panel:form");
        this.formTester.setValue("panel:passwordPolicyName", "master");
        this.formTester.setValue("panel:checkInterval", "5001");
        this.formTester.setValue("panel:validating", false);
        this.clickSave();
        tester.assertNoErrorMessage();
        tester.assertRenderedPage(this.basePage.getClass());
        xmlConfig = (XMLUserGroupServiceConfig)this.getSecurityNamedServiceConfig("default2");
        Assert.assertEquals((Object)this.getDigestPasswordEncoder().getName(), (Object)xmlConfig.getPasswordEncoderName());
        Assert.assertEquals((Object)"master", (Object)xmlConfig.getPasswordPolicyName());
        Assert.assertEquals((Object)"abc.xml", (Object)xmlConfig.getFileName());
        Assert.assertEquals((long)5001L, (long)xmlConfig.getCheckInterval());
        Assert.assertEquals((Object)false, (Object)xmlConfig.isValidating());
        xmlConfig = (XMLUserGroupServiceConfig)this.getSecurityManager().loadUserGroupServiceConfig("default2");
        Assert.assertEquals((Object)this.getDigestPasswordEncoder().getName(), (Object)xmlConfig.getPasswordEncoderName());
        Assert.assertEquals((Object)"master", (Object)xmlConfig.getPasswordPolicyName());
        Assert.assertEquals((Object)"abc.xml", (Object)xmlConfig.getFileName());
        Assert.assertEquals((long)5001L, (long)xmlConfig.getCheckInterval());
        Assert.assertEquals((Object)false, (Object)xmlConfig.isValidating());
    }

    @Test
    public void testRemove() throws Exception {
        this.initializeForXML();
        XMLUserGroupServiceConfig config = new XMLUserGroupServiceConfig();
        config.setName("default3");
        config.setClassName(XMLUserGroupService.class.getCanonicalName());
        config.setPasswordEncoderName(this.getPlainTextPasswordEncoder().getName());
        config.setPasswordPolicyName("default");
        config.setFileName("foo.xml");
        this.getSecurityManager().saveUserGroupService((SecurityUserGroupServiceConfig)config);
        this.activatePanel();
        this.doRemove("tabbedPanel:panel:removeSelected", "default3");
        Assert.assertNull((Object)this.getSecurityManager().loadUserGroupService("default3"));
    }
}

