/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.markup.html.list.ListView;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.security.config.SecurityManagerConfig;
import org.geoserver.security.web.AbstractSecurityWicketTestSupport;
import org.geoserver.web.FormTestPage;
import org.junit.Assert;

public abstract class AbstractConfirmRemovalPanelTest<T>
extends AbstractSecurityWicketTestSupport
implements Serializable {
    private static final long serialVersionUID = 1L;

    protected abstract void setupPanel(List<T> var1);

    protected abstract T getRemoveableObject() throws Exception;

    protected abstract T getProblematicObject() throws Exception;

    protected abstract String getProblematicObjectRegExp() throws Exception;

    protected abstract String getRemoveableObjectRegExp() throws Exception;

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        SecurityManagerConfig config = this.getSecurityManager().getSecurityConfig();
        config.setEncryptingUrlParams(false);
        this.getSecurityManager().saveSecurityConfig(config);
    }

    protected void removeObject() throws Exception {
        this.insertValues();
        T removeableObject = this.getRemoveableObject();
        Assert.assertNotNull(removeableObject);
        this.setupPanel(Collections.singletonList(removeableObject));
        tester.assertRenderedPage(FormTestPage.class);
        tester.assertNoErrorMessage();
        Assert.assertTrue((boolean)this.labelTextForRemovedObjects().matches(this.getRemoveableObjectRegExp()));
        tester.assertVisible("form:panel:removedObjects");
        tester.assertInvisible("form:panel:problematicObjects");
        T problematicObject = this.getProblematicObject();
        if (problematicObject != null) {
            this.setupPanel(Collections.singletonList(problematicObject));
            tester.assertRenderedPage(FormTestPage.class);
            tester.assertNoErrorMessage();
            Assert.assertTrue((boolean)this.labelTextForProblematicObjects().matches(this.getProblematicObjectRegExp()));
            tester.assertInvisible("form:panel:removedObjects");
            tester.assertVisible("form:panel:problematicObjects");
        }
        if (removeableObject != null && problematicObject != null) {
            ArrayList<T> objects = new ArrayList<T>();
            objects.add(removeableObject);
            objects.add(problematicObject);
            this.setupPanel(objects);
            tester.assertRenderedPage(FormTestPage.class);
            tester.assertNoErrorMessage();
            Assert.assertTrue((boolean)this.labelTextForRemovedObjects().matches(this.getRemoveableObjectRegExp()));
            Assert.assertTrue((boolean)this.labelTextForProblematicObjects().matches(this.getProblematicObjectRegExp()));
            tester.assertVisible("form:panel:removedObjects");
            tester.assertVisible("form:panel:problematicObjects");
        }
    }

    protected String labelTextForRemovedObjects() {
        ListView list = (ListView)tester.getComponentFromLastRenderedPage("form:panel:removedObjects:rulesRemoved:rules");
        return list.getDefaultModelObjectAsString();
    }

    protected String labelTextForProblematicObjects() {
        ListView list = (ListView)tester.getComponentFromLastRenderedPage("form:panel:problematicObjects:rulesNotRemoved:problems");
        return list.getDefaultModelObjectAsString();
    }
}

