/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web;

import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.FormComponent;
import org.geoserver.security.web.AbstractSecurityPage;
import org.geoserver.security.web.AbstractSecurityWicketTestSupport;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractTabbedListPageTest<T>
extends AbstractSecurityWicketTestSupport {
    public static final String FIRST_COLUM_PATH = "itemProperties:0:component:link";

    @Override
    @Before
    public void setUp() throws Exception {
        this.login();
    }

    @Before
    public void initService() throws Exception {
        this.doInitialize();
        this.clearServices();
        this.insertValues();
    }

    protected void doInitialize() throws Exception {
        this.initializeForXML();
    }

    @Test
    public void testRenders() throws Exception {
        tester.assertRenderedPage(this.listPage(this.getServiceName()).getClass());
    }

    protected String getItemsPath() {
        return this.getTabbedPanelPath() + ":panel:table:listContainer:items";
    }

    protected abstract String getTabbedPanelPath();

    protected abstract String getServiceName();

    protected abstract Page listPage(String var1);

    protected abstract Page newPage(AbstractSecurityPage var1, Object ... var2);

    protected abstract Page editPage(AbstractSecurityPage var1, Object ... var2);

    protected abstract String getSearchString() throws Exception;

    protected abstract GeoServerDataProvider.Property<T> getEditProperty();

    protected abstract boolean checkEditForm(String var1);

    @Test
    public void testEdit() throws Exception {
        AbstractSecurityPage listPage = (AbstractSecurityPage)this.listPage(this.getServiceName());
        String search = this.getSearchString();
        Assert.assertNotNull((Object)search);
        Component c = this.getFromList(FIRST_COLUM_PATH, search, this.getEditProperty());
        Assert.assertNotNull((Object)c);
        tester.clickLink(c.getPageRelativePath());
        tester.assertRenderedPage(this.editPage(listPage, new Object[0]).getClass());
        Assert.assertTrue((boolean)this.checkEditForm(search));
    }

    protected Component getFromList(String columnPath, Object columnValue, GeoServerDataProvider.Property<T> property) {
        MarkupContainer listView = (MarkupContainer)tester.getLastRenderedPage().get(this.getItemsPath());
        for (MarkupContainer m : listView) {
            Component c = m.get(columnPath);
            Object modelObject = c.getDefaultModelObject();
            if (!columnValue.equals(property.getPropertyValue(modelObject))) continue;
            return c;
        }
        return null;
    }

    @Test
    public void testNew() throws Exception {
        this.listPage(this.getServiceName());
        tester.clickLink(this.getTabbedPanelPath() + ":panel:header:addNew");
        Page newPage = tester.getLastRenderedPage();
        tester.assertRenderedPage(newPage.getClass());
    }

    @Test
    public void testRemove() throws Exception {
        this.addAdditonalData();
        this.doRemove(this.getTabbedPanelPath() + ":panel:header:removeSelected");
    }

    protected void doRemove(String pathForLink) throws Exception {
        Page testPage = this.listPage(this.getServiceName());
        String selectAllPath = this.getTabbedPanelPath() + ":panel:table:listContainer:selectAllContainer:selectAll";
        tester.assertComponent(selectAllPath, CheckBox.class);
        CheckBox selectAllComponent = (CheckBox)tester.getComponentFromLastRenderedPage(selectAllPath);
        this.setFormComponentValue((FormComponent)selectAllComponent, "true");
        tester.executeAjaxEvent(selectAllPath, "click");
        String windowPath = this.getTabbedPanelPath() + ":panel:dialog:dialog";
        ModalWindow w = (ModalWindow)testPage.get(windowPath);
        Assert.assertNull((Object)w.getTitle());
        tester.executeAjaxEvent(pathForLink, "click");
        Assert.assertNotNull((Object)w.getTitle());
        this.simulateDeleteSubmit();
        this.executeModalWindowCloseButtonCallback(w);
    }

    protected abstract void simulateDeleteSubmit() throws Exception;

    protected Component getRemoveLink() {
        Component result = tester.getLastRenderedPage().get(this.getTabbedPanelPath() + ":panel:header:removeSelected");
        Assert.assertNotNull((Object)result);
        return result;
    }

    protected Component getRemoveLinkWithRoles() {
        Component result = tester.getLastRenderedPage().get(this.getTabbedPanelPath() + ":panel:header:removeSelectedWithRoles");
        Assert.assertNotNull((Object)result);
        return result;
    }

    protected Component getAddLink() {
        Component result = tester.getLastRenderedPage().get(this.getTabbedPanelPath() + ":panel:header:addNew");
        Assert.assertNotNull((Object)result);
        return result;
    }
}

