/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.auth;

import java.util.List;
import org.apache.wicket.Page;
import org.apache.wicket.extensions.markup.html.form.palette.component.Recorder;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.security.GeoServerAuthenticationProvider;
import org.geoserver.security.auth.UsernamePasswordAuthenticationProvider;
import org.geoserver.security.web.AbstractSecurityWicketTestSupport;
import org.geoserver.security.web.auth.AuthenticationPage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AuthenticationPageTest
extends AbstractSecurityWicketTestSupport {
    AuthenticationPage page;

    @Before
    public void init() throws Exception {
        this.deactivateRORoleService();
    }

    @Test
    public void testSetProvider() throws Exception {
        this.initializeForXML();
        this.createUserPasswordAuthProvider("default2", "default");
        this.activateRORoleService();
        this.page = new AuthenticationPage();
        tester.startPage((Page)this.page);
        tester.assertComponent("form:providerChain:authProviderNames:recorder", Recorder.class);
        List selected = (List)this.page.get("form:providerChain:authProviderNames").getDefaultModelObject();
        Assert.assertEquals((long)1L, (long)selected.size());
        Assert.assertTrue((boolean)selected.contains("default"));
        FormTester form = tester.newFormTester("form");
        form.setValue("providerChain:authProviderNames:recorder", "default2");
        form.submit("save");
        tester.assertNoErrorMessage();
        boolean authProvFound = false;
        for (GeoServerAuthenticationProvider prov : this.getSecurityManager().getAuthenticationProviders()) {
            if (!UsernamePasswordAuthenticationProvider.class.isAssignableFrom(prov.getClass()) || !((UsernamePasswordAuthenticationProvider)prov).getName().equals("default2")) continue;
            authProvFound = true;
            break;
        }
        Assert.assertTrue((boolean)authProvFound);
    }

    protected boolean hasAuthProviderImpl(Class<?> aClass) {
        for (Object o : this.getSecurityManager().getProviders()) {
            if (o.getClass() != aClass) continue;
            return true;
        }
        return false;
    }
}

