/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.passwd;

import org.apache.wicket.Component;
import org.geoserver.security.config.PasswordPolicyConfig;
import org.geoserver.security.validation.PasswordValidatorImpl;
import org.geoserver.security.web.AbstractSecurityNamedServicePanelTest;
import org.geoserver.security.web.AbstractSecurityPage;
import org.geoserver.security.web.SecurityNamedServiceEditPage;
import org.geoserver.security.web.SecurityNamedServiceNewPage;
import org.geoserver.security.web.passwd.PasswordPage;
import org.geoserver.security.web.passwd.PasswordPoliciesPanel;
import org.geoserver.security.web.passwd.PasswordPolicyPanelInfo;
import org.junit.Assert;
import org.junit.Test;

public class PasswordPolicyDetailsPanelTest
extends AbstractSecurityNamedServicePanelTest {
    @Override
    protected String getDetailsFormComponentId() {
        return "passwordPolicyPanel:namedConfig";
    }

    @Override
    protected AbstractSecurityPage getBasePage() {
        return new PasswordPage();
    }

    @Override
    protected String getBasePanelId() {
        return "form:passwordPolicies";
    }

    @Override
    protected Integer getTabIndex() {
        return 2;
    }

    @Override
    protected Class<? extends Component> getNamedServicesClass() {
        return PasswordPoliciesPanel.class;
    }

    protected void setDigitRequired(boolean value) {
        this.formTester.setValue("panel:content:digitRequired", value);
    }

    protected boolean getDigitRequired(boolean value) {
        return (Boolean)this.formTester.getForm().get("details:config.digitRequired").getDefaultModelObject();
    }

    protected void setUpperCaseRequired(boolean value) {
        this.formTester.setValue("panel:content:uppercaseRequired", value);
    }

    protected boolean getUpperCaseRequired(boolean value) {
        return (Boolean)this.formTester.getForm().get("details:config.uppercaseRequired").getDefaultModelObject();
    }

    protected void setLowerCaseRequired(boolean value) {
        this.formTester.setValue("panel:content:lowercaseRequired", value);
    }

    protected boolean getLowerCaseRequired(boolean value) {
        return (Boolean)this.formTester.getForm().get("details:config.lowercaseRequired").getDefaultModelObject();
    }

    protected void setUnlimted(boolean value) {
        this.formTester.setValue("panel:content:unlimitedMaxLength", value);
        tester.executeAjaxEvent("form:panel:content:unlimitedMaxLength", "click");
    }

    protected boolean getUnlimted(boolean value) {
        return (Boolean)this.formTester.getForm().get("details:unlimited").getDefaultModelObject();
    }

    protected void setMinLength(int value) {
        this.formTester.setValue("panel:content:minLength", new Integer(value).toString());
    }

    protected int getMinLength(int value) {
        return (Integer)this.formTester.getForm().get("details:config.minLength").getDefaultModelObject();
    }

    protected void setMaxLength(int value) {
        this.formTester.setValue("panel:content:maxLength:maxLength", new Integer(value).toString());
    }

    protected int getMaxLength(int value) {
        return (Integer)this.formTester.getForm().get("details:config.maxLength").getDefaultModelObject();
    }

    @Test
    public void testAddModify() throws Exception {
        this.initializeForXML();
        this.activatePanel();
        Assert.assertEquals((long)2L, (long)this.countItems());
        Assert.assertNotNull((Object)this.getSecurityNamedServiceConfig("default"));
        Assert.assertNull((Object)this.getSecurityNamedServiceConfig("xxxxxxxx"));
        this.clickAddNew();
        tester.assertRenderedPage(SecurityNamedServiceNewPage.class);
        this.newFormTester();
        this.setSecurityConfigClassName(PasswordPolicyPanelInfo.class);
        this.newFormTester();
        this.setSecurityConfigName("default2");
        this.setMinLength(5);
        this.clickCancel();
        tester.assertRenderedPage(this.basePage.getClass());
        Assert.assertEquals((long)2L, (long)this.countItems());
        Assert.assertNotNull((Object)this.getSecurityNamedServiceConfig("default"));
        Assert.assertNotNull((Object)this.getSecurityNamedServiceConfig("master"));
        this.clickAddNew();
        this.newFormTester();
        this.setSecurityConfigClassName(PasswordPolicyPanelInfo.class);
        this.setUnlimted(false);
        tester.assertVisible("form:panel:content:maxLength:maxLength");
        this.newFormTester();
        this.setSecurityConfigName("default2");
        this.setDigitRequired(true);
        this.setUpperCaseRequired(true);
        this.setLowerCaseRequired(true);
        this.setMinLength(2);
        this.setMaxLength(4);
        this.clickSave();
        tester.assertRenderedPage(this.basePage.getClass());
        Assert.assertEquals((long)3L, (long)this.countItems());
        Assert.assertNotNull((Object)this.getSecurityNamedServiceConfig("default"));
        Assert.assertNotNull((Object)this.getSecurityNamedServiceConfig("master"));
        PasswordPolicyConfig pwConfig = (PasswordPolicyConfig)this.getSecurityNamedServiceConfig("default2");
        Assert.assertNotNull((Object)pwConfig);
        Assert.assertEquals((Object)"default2", (Object)pwConfig.getName());
        Assert.assertEquals((Object)PasswordValidatorImpl.class.getName(), (Object)pwConfig.getClassName());
        Assert.assertTrue((boolean)pwConfig.isDigitRequired());
        Assert.assertTrue((boolean)pwConfig.isLowercaseRequired());
        Assert.assertTrue((boolean)pwConfig.isUppercaseRequired());
        Assert.assertEquals((long)2L, (long)pwConfig.getMinLength());
        Assert.assertEquals((long)4L, (long)pwConfig.getMaxLength());
        pwConfig = this.getSecurityManager().loadPasswordPolicyConfig("default2");
        Assert.assertNotNull((Object)pwConfig);
        Assert.assertEquals((Object)"default2", (Object)pwConfig.getName());
        Assert.assertEquals((Object)PasswordValidatorImpl.class.getName(), (Object)pwConfig.getClassName());
        Assert.assertTrue((boolean)pwConfig.isDigitRequired());
        Assert.assertTrue((boolean)pwConfig.isLowercaseRequired());
        Assert.assertTrue((boolean)pwConfig.isUppercaseRequired());
        Assert.assertEquals((long)2L, (long)pwConfig.getMinLength());
        Assert.assertEquals((long)4L, (long)pwConfig.getMaxLength());
        this.clickAddNew();
        this.newFormTester();
        this.setSecurityConfigClassName(PasswordPolicyPanelInfo.class);
        this.newFormTester();
        this.setSecurityConfigName("default2");
        this.clickSave();
        tester.assertRenderedPage(SecurityNamedServiceNewPage.class);
        this.testErrorMessagesWithRegExp(".*default2.*");
        this.clickCancel();
        tester.assertRenderedPage(this.basePage.getClass());
        this.clickNamedServiceConfig("default2");
        tester.assertRenderedPage(SecurityNamedServiceEditPage.class);
        this.newFormTester("panel:panel:form");
        this.formTester.setValue("panel:maxLength:maxLength", "27");
        this.clickCancel();
        tester.assertRenderedPage(this.basePage.getClass());
        pwConfig = (PasswordPolicyConfig)this.getSecurityNamedServiceConfig("default2");
        Assert.assertEquals((long)4L, (long)pwConfig.getMaxLength());
        this.clickNamedServiceConfig("default2");
        this.newFormTester("panel:panel:form");
        this.formTester.setValue("panel:unlimitedMaxLength", true);
        tester.executeAjaxEvent("panel:panel:form:panel:unlimitedMaxLength", "click");
        tester.assertInvisible("panel:panel:form:panel:maxLength:maxLength");
        this.newFormTester("panel:panel:form");
        this.formTester.setValue("panel:digitRequired", false);
        this.formTester.setValue("panel:uppercaseRequired", false);
        this.formTester.setValue("panel:lowercaseRequired", false);
        this.formTester.setValue("panel:minLength", "3");
        this.clickSave();
        tester.assertRenderedPage(this.basePage.getClass());
        pwConfig = (PasswordPolicyConfig)this.getSecurityNamedServiceConfig("default2");
        Assert.assertFalse((boolean)pwConfig.isDigitRequired());
        Assert.assertFalse((boolean)pwConfig.isLowercaseRequired());
        Assert.assertFalse((boolean)pwConfig.isUppercaseRequired());
        Assert.assertEquals((long)3L, (long)pwConfig.getMinLength());
        Assert.assertEquals((long)-1L, (long)pwConfig.getMaxLength());
        pwConfig = this.getSecurityManager().loadPasswordPolicyConfig("default2");
        Assert.assertFalse((boolean)pwConfig.isDigitRequired());
        Assert.assertFalse((boolean)pwConfig.isLowercaseRequired());
        Assert.assertFalse((boolean)pwConfig.isUppercaseRequired());
        Assert.assertEquals((long)3L, (long)pwConfig.getMinLength());
        Assert.assertEquals((long)-1L, (long)pwConfig.getMaxLength());
    }

    @Test
    public void testRemove() throws Exception {
        this.initializeForXML();
        PasswordPolicyConfig config = new PasswordPolicyConfig();
        config.setName("default3");
        config.setClassName(PasswordValidatorImpl.class.getCanonicalName());
        this.getSecurityManager().savePasswordPolicy(config);
        this.activatePanel();
        this.doRemove(null, "default3");
        Assert.assertNull((Object)this.getSecurityManager().loadPasswordPolicyConfig("default3"));
    }
}

