/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.auth;

import java.util.Arrays;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.OnChangeAjaxBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.EmptyPanel;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.geoserver.security.config.PreAuthenticatedUserNameFilterConfig;
import org.geoserver.security.config.RoleSource;
import org.geoserver.security.web.auth.AuthenticationFilterPanel;
import org.geoserver.security.web.auth.RoleSourceChoiceRenderer;
import org.geoserver.security.web.role.RoleServiceChoice;
import org.geoserver.security.web.usergroup.UserGroupServiceChoice;
import org.geoserver.web.wicket.HelpLink;

public abstract class PreAuthenticatedUserNameFilterPanel<T extends PreAuthenticatedUserNameFilterConfig>
extends AuthenticationFilterPanel<T> {
    DropDownChoice<RoleSource> roleSourceChoice;

    public PreAuthenticatedUserNameFilterPanel(String id, IModel<T> model) {
        super(id, model);
        this.add(new Component[]{new HelpLink("roleSourceHelp", (Component)this).setDialog(this.dialog)});
        this.createRoleSourceDropDown();
        this.roleSourceChoice.setNullValid(false);
        this.roleSourceChoice.add(new Behavior[]{new OnChangeAjaxBehavior(){

            protected void onUpdate(AjaxRequestTarget target) {
                Panel p = PreAuthenticatedUserNameFilterPanel.this.getRoleSourcePanel((RoleSource)PreAuthenticatedUserNameFilterPanel.this.roleSourceChoice.getModelObject());
                WebMarkupContainer c = (WebMarkupContainer)PreAuthenticatedUserNameFilterPanel.this.get("container");
                c.addOrReplace(new Component[]{p});
                target.add(new Component[]{c});
            }
        }});
        WebMarkupContainer container = new WebMarkupContainer("container");
        this.add(new Component[]{container.setOutputMarkupId(true)});
        RoleSource rs = ((PreAuthenticatedUserNameFilterConfig)model.getObject()).getRoleSource();
        this.addRoleSourceDropDown(container, rs);
    }

    protected Panel getRoleSourcePanel(RoleSource model) {
        if (PreAuthenticatedUserNameFilterConfig.PreAuthenticatedUserNameRoleSource.UserGroupService.equals(model)) {
            return new UserGroupServicePanel("panel");
        }
        if (PreAuthenticatedUserNameFilterConfig.PreAuthenticatedUserNameRoleSource.RoleService.equals(model)) {
            return new RoleServicePanel("panel");
        }
        if (PreAuthenticatedUserNameFilterConfig.PreAuthenticatedUserNameRoleSource.Header.equals(model)) {
            return new HeaderPanel("panel");
        }
        return new EmptyPanel("panel");
    }

    protected void createRoleSourceDropDown() {
        Component[] componentArray = new Component[1];
        this.roleSourceChoice = new DropDownChoice("roleSource", Arrays.asList(PreAuthenticatedUserNameFilterConfig.PreAuthenticatedUserNameRoleSource.values()), (IChoiceRenderer)new RoleSourceChoiceRenderer());
        componentArray[0] = this.roleSourceChoice;
        this.add(componentArray);
    }

    protected void addRoleSourceDropDown(WebMarkupContainer container, RoleSource rs) {
        container.addOrReplace(new Component[]{this.getRoleSourcePanel(rs)});
    }

    static class RoleServicePanel
    extends Panel {
        public RoleServicePanel(String id) {
            super(id, (IModel)new Model());
            this.add(new Component[]{new RoleServiceChoice("roleServiceName")});
        }
    }

    static class UserGroupServicePanel
    extends Panel {
        public UserGroupServicePanel(String id) {
            super(id, (IModel)new Model());
            this.add(new Component[]{new UserGroupServiceChoice("userGroupServiceName").setRequired(true)});
        }
    }

    static class HeaderPanel
    extends Panel {
        public HeaderPanel(String id) {
            super(id, (IModel)new Model());
            this.add(new Component[]{new TextField("rolesHeaderAttribute").setRequired(true)});
        }
    }
}

