/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.data;

import java.io.Serializable;
import java.util.List;
import org.apache.wicket.Page;
import org.apache.wicket.extensions.markup.html.form.palette.component.Recorder;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.data.test.MockData;
import org.geoserver.security.AccessMode;
import org.geoserver.security.impl.DataAccessRule;
import org.geoserver.security.impl.DataAccessRuleDAO;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.web.AbstractSecurityWicketTestSupport;
import org.geoserver.security.web.data.DataSecurityPage;
import org.geoserver.security.web.data.EditDataAccessRulePage;
import org.geoserver.security.web.role.NewRolePage;
import org.geoserver.test.RunTestSetup;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EditDataAccessRulePageTest
extends AbstractSecurityWicketTestSupport {
    EditDataAccessRulePage page;
    String ruleName = String.valueOf(MockData.CITE_PREFIX) + "." + MockData.LAKES.getLocalPart() + "." + AccessMode.WRITE.getAlias();

    @Before
    public void init() throws Exception {
        this.initializeForXML();
        this.clearServices();
        DataAccessRuleDAO.get().clear();
    }

    @Test
    public void testFill() throws Exception {
        this.page = new EditDataAccessRulePage(this.getRule(this.ruleName));
        tester.startPage((Page)this.page);
        tester.assertRenderedPage(EditDataAccessRulePage.class);
        tester.assertModelValue("form:root", (Object)MockData.CITE_PREFIX);
        tester.assertModelValue("form:layerContainer:layerAndLabel:layer", (Object)MockData.LAKES.getLocalPart());
        tester.assertModelValue("form:accessMode", (Object)AccessMode.WRITE);
        tester.assertModelValue("form:roles:anyRole", (Object)Boolean.FALSE);
        tester.assertComponent("form:roles:palette:recorder", Recorder.class);
        FormTester form = tester.newFormTester("form");
        form.setValue("roles:anyRole", true);
        form.submit("roles:addRole");
        tester.assertRenderedPage(NewRolePage.class);
        tester.clickLink("form:cancel");
        tester.assertRenderedPage(EditDataAccessRulePage.class);
        form = tester.newFormTester("form");
        form.setValue("roles:anyRole", true);
        form.submit("save");
        tester.assertErrorMessages((Serializable[])new String[0]);
        tester.assertRenderedPage(DataSecurityPage.class);
        DataAccessRule rule = this.getRule(this.ruleName);
        Assert.assertNotNull((Object)rule);
        Assert.assertEquals((long)1L, (long)rule.getRoles().size());
        Assert.assertEquals((Object)GeoServerRole.ANY_ROLE, rule.getRoles().iterator().next());
    }

    @Test
    @RunTestSetup
    public void testEmptyRoles() throws Exception {
        this.initializeServiceRules();
        this.page = new EditDataAccessRulePage(this.getRule(this.ruleName));
        tester.startPage((Page)this.page);
        FormTester form = tester.newFormTester("form");
        form.setValue("roles:palette:recorder", "");
        form.submit("save");
        tester.assertRenderedPage(EditDataAccessRulePage.class);
        Assert.assertTrue((boolean)this.testErrorMessagesWithRegExp(".*no role.*"));
        tester.assertRenderedPage(EditDataAccessRulePage.class);
    }

    @Test
    public void testReadOnlyRoleService() throws Exception {
        this.activateRORoleService();
        this.page = new EditDataAccessRulePage(this.getRule(this.ruleName));
        tester.startPage((Page)this.page);
        tester.assertInvisible("form:roles:addRole");
    }

    protected int indexOf(List<? extends String> strings, String searchValue) {
        int index = 0;
        for (String string : strings) {
            if (string.equals(searchValue)) {
                return index;
            }
            ++index;
        }
        Assert.assertTrue((index != -1 ? 1 : 0) != 0);
        return -1;
    }

    DataAccessRule getRule(String key) {
        DataAccessRuleDAO.get().reload();
        for (DataAccessRule rule : DataAccessRuleDAO.get().getRules()) {
            if (!key.equals(rule.getKey())) continue;
            return rule;
        }
        return null;
    }
}

