/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.group;

import java.lang.reflect.Method;
import java.util.SortedSet;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.geoserver.security.impl.GeoServerUserGroup;
import org.geoserver.security.web.AbstractSecurityPage;
import org.geoserver.security.web.AbstractTabbedListPageTest;
import org.geoserver.security.web.group.EditGroupPage;
import org.geoserver.security.web.group.GroupListProvider;
import org.geoserver.security.web.group.NewGroupPage;
import org.geoserver.security.web.group.SelectionGroupRemovalLink;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GroupListPageTest
extends AbstractTabbedListPageTest<GeoServerUserGroup> {
    protected boolean withRoles = false;

    protected AbstractSecurityPage listPage(String serviceName) {
        AbstractSecurityPage result = this.initializeForUGServiceNamed(serviceName);
        tester.clickLink(String.valueOf(this.getTabbedPanelPath()) + ":tabs-container:tabs:2:link", true);
        return result;
    }

    @Override
    protected Page newPage(AbstractSecurityPage page, Object ... params) {
        if (params.length == 0) {
            return new NewGroupPage(this.getUserGroupServiceName()).setReturnPage((Page)page);
        }
        return new NewGroupPage((String)params[0]).setReturnPage((Page)page);
    }

    @Override
    protected Page editPage(AbstractSecurityPage page, Object ... params) {
        if (params.length == 0) {
            return new EditGroupPage(this.getUserGroupServiceName(), new GeoServerUserGroup("dummygroup")).setReturnPage((Page)page);
        }
        if (params.length == 1) {
            return new EditGroupPage(this.getUserGroupServiceName(), (GeoServerUserGroup)params[0]).setReturnPage((Page)page);
        }
        return new EditGroupPage((String)params[0], (GeoServerUserGroup)params[1]).setReturnPage((Page)page);
    }

    @Override
    protected String getSearchString() throws Exception {
        GeoServerUserGroup g = this.ugService.getGroupByGroupname("admins");
        Assert.assertNotNull((Object)g);
        return g.getGroupname();
    }

    @Override
    protected GeoServerDataProvider.Property<GeoServerUserGroup> getEditProperty() {
        return GroupListProvider.GROUPNAME;
    }

    @Override
    protected boolean checkEditForm(String objectString) {
        return objectString.equals(tester.getComponentFromLastRenderedPage("form:groupname").getDefaultModelObject());
    }

    @Before
    public void init() throws Exception {
    }

    @Test
    public void testReadOnlyService() throws Exception {
        tester.startPage((Page)this.listPage(this.getUserGroupServiceName()));
        tester.assertVisible(this.getRemoveLink().getPageRelativePath());
        tester.assertVisible(this.getRemoveLinkWithRoles().getPageRelativePath());
        tester.assertVisible(this.getAddLink().getPageRelativePath());
        this.activateRORoleService();
        tester.startPage((Page)this.listPage(this.getUserGroupServiceName()));
        tester.assertVisible(this.getRemoveLink().getPageRelativePath());
        tester.assertInvisible(this.getRemoveLinkWithRoles().getPageRelativePath());
        tester.assertVisible(this.getAddLink().getPageRelativePath());
        this.activateROUGService();
        tester.startPage((Page)this.listPage(this.getROUserGroupServiceName()));
        tester.assertInvisible(this.getRemoveLink().getPageRelativePath());
        tester.assertInvisible(this.getAddLink().getPageRelativePath());
        tester.assertInvisible(this.getRemoveLinkWithRoles().getPageRelativePath());
    }

    @Override
    protected void simulateDeleteSubmit() throws Exception {
        SelectionGroupRemovalLink link = (SelectionGroupRemovalLink)(this.withRoles ? this.getRemoveLinkWithRoles() : this.getRemoveLink());
        Method m = link.delegate.getClass().getDeclaredMethod("onSubmit", AjaxRequestTarget.class, Component.class);
        m.invoke((Object)link.delegate, new Object[]{null, null});
        SortedSet groups = this.ugService.getUserGroups();
        Assert.assertTrue((groups.size() == 0 ? 1 : 0) != 0);
        if (this.withRoles) {
            Assert.assertTrue((this.gaService.getRolesForGroup("group1").size() == 0 ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((this.gaService.getRolesForGroup("group1").size() == 2 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testRemoveWithRoles() throws Exception {
        this.withRoles = true;
        this.addAdditonalData();
        this.doRemove(String.valueOf(this.getTabbedPanelPath()) + ":panel:header:removeSelectedWithRoles");
    }

    @Override
    protected String getTabbedPanelPath() {
        return "panel:panel";
    }

    @Override
    protected String getServiceName() {
        return this.getUserGroupServiceName();
    }
}

