/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.role;

import java.io.Serializable;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.web.AbstractSecurityPage;
import org.geoserver.security.web.AbstractSecurityWicketTestSupport;
import org.geoserver.security.web.SecurityNamedServiceEditPage;
import org.geoserver.security.web.role.NewRolePage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NewRolePageTest
extends AbstractSecurityWicketTestSupport {
    NewRolePage page;

    @Before
    public void init() throws Exception {
        this.doInitialize();
        this.clearServices();
    }

    @Test
    public void testFill() throws Exception {
        this.doTestFill();
    }

    protected void doInitialize() throws Exception {
        this.initializeForXML();
    }

    protected void doTestFill() throws Exception {
        this.insertValues();
        AbstractSecurityPage returnPage = this.initializeForRoleServiceNamed(this.getRoleServiceName());
        this.page = (NewRolePage)new NewRolePage(this.getRoleServiceName()).setReturnPage((Page)returnPage);
        tester.startPage((Page)this.page);
        tester.assertRenderedPage(NewRolePage.class);
        FormTester form = tester.newFormTester("form");
        form.setValue("name", "ROLE_TEST");
        int index = -1;
        for (String name : ((DropDownChoice)this.page.get("form:parent")).getChoices()) {
            ++index;
            if ("ROLE_AUTHENTICATED".equals(name)) break;
        }
        Assert.assertTrue((index >= 0 ? 1 : 0) != 0);
        form.select("parent", index);
        form.submit("save");
        tester.assertRenderedPage(SecurityNamedServiceEditPage.class);
        tester.assertErrorMessages((Serializable[])new String[0]);
        GeoServerRole role = this.gaService.getRoleByName("ROLE_TEST");
        Assert.assertNotNull((Object)role);
        GeoServerRole parentRole = this.gaService.getParentRole(role);
        Assert.assertNotNull((Object)parentRole);
        Assert.assertEquals((Object)"ROLE_AUTHENTICATED", (Object)parentRole.getAuthority());
    }

    @Test
    public void testRoleNameConflict() throws Exception {
        this.insertValues();
        AbstractSecurityPage returnPage = this.initializeForRoleServiceNamed(this.getRoleServiceName());
        this.page = (NewRolePage)new NewRolePage(this.getRoleServiceName()).setReturnPage((Page)returnPage);
        tester.startPage((Page)this.page);
        FormTester form = tester.newFormTester("form");
        form.setValue("name", "ROLE_WFS");
        form.submit("save");
        Assert.assertTrue((boolean)this.testErrorMessagesWithRegExp(".*ROLE_WFS.*"));
        tester.getMessages(400);
        tester.assertRenderedPage(NewRolePage.class);
    }

    @Test
    public void testInvalidWorkflow() throws Exception {
        this.activateRORoleService();
        AbstractSecurityPage returnPage = this.initializeForRoleServiceNamed(this.getRORoleServiceName());
        boolean fail = true;
        try {
            this.page = (NewRolePage)new NewRolePage(this.getRORoleServiceName()).setReturnPage((Page)returnPage);
            tester.startPage((Page)this.page);
        }
        catch (RuntimeException ex) {
            fail = false;
        }
        if (fail) {
            Assert.fail((String)"No runtime exception for read only RoleService");
        }
    }
}

