/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.user;

import java.io.Serializable;
import java.util.SortedSet;
import org.apache.wicket.Page;
import org.apache.wicket.extensions.markup.html.form.palette.component.Recorder;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.impl.GeoServerUser;
import org.geoserver.security.impl.GeoServerUserGroup;
import org.geoserver.security.web.AbstractSecurityPage;
import org.geoserver.security.web.SecurityNamedServiceEditPage;
import org.geoserver.security.web.user.AbstractUserPage;
import org.geoserver.security.web.user.AbstractUserPageTest;
import org.geoserver.security.web.user.NewUserPage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NewUserPageTest
extends AbstractUserPageTest {
    @Override
    protected void initializeTester() {
        AbstractSecurityPage returnPage = this.initializeForUGServiceNamed(this.getUserGroupServiceName());
        this.page = (AbstractUserPage)new NewUserPage(this.getUserGroupServiceName()).setReturnPage((Page)returnPage);
        tester.startPage((Page)this.page);
    }

    @Before
    public void init() throws Exception {
        this.doInitialize();
        this.clearServices();
    }

    @Override
    protected void doInitialize() throws Exception {
        this.initializeForXML();
    }

    @Test
    public void testFill() throws Exception {
        this.doTestFill();
    }

    protected void doTestFill() throws Exception {
        this.insertValues();
        this.initializeTester();
        tester.assertRenderedPage(NewUserPage.class);
        this.newFormTester();
        this.form.setValue("username", "testuser");
        this.form.setValue("password", "pwd");
        this.form.setValue("confirmPassword", "pwd");
        Assert.assertTrue((boolean)((GeoServerUser)this.page.get("form").getDefaultModelObject()).isEnabled());
        this.form.setValue("enabled", false);
        Assert.assertTrue((boolean)this.page.userGroupPalette.isEnabled());
        tester.assertComponent("form:roles:palette:recorder", Recorder.class);
        this.addNewRole("ROLE_NEW");
        tester.assertRenderedPage(NewUserPage.class);
        tester.assertNoErrorMessage();
        this.assignRole("ROLE_NEW");
        this.openCloseRolePanel(NewUserPage.class);
        tester.assertNoErrorMessage();
        this.addNewGroup("testgroup");
        this.assignGroup("testgroup");
        tester.assertNoErrorMessage();
        this.openCloseGroupPanel(NewUserPage.class);
        tester.assertNoErrorMessage();
        this.assertCalculatedRoles(new String[]{"ROLE_NEW"});
        this.form.submit("save");
        tester.assertNoErrorMessage();
        tester.assertRenderedPage(SecurityNamedServiceEditPage.class);
        GeoServerUser user = this.ugService.getUserByUsername("testuser");
        Assert.assertNotNull((Object)user);
        Assert.assertFalse((boolean)user.isEnabled());
        SortedSet groupList = this.ugService.getGroupsForUser(user);
        Assert.assertEquals((long)1L, (long)groupList.size());
        Assert.assertEquals((Object)"testgroup", (Object)((GeoServerUserGroup)groupList.iterator().next()).getGroupname());
        SortedSet roleList = this.gaService.getRolesForUser("testuser");
        Assert.assertEquals((long)1L, (long)roleList.size());
        Assert.assertEquals((Object)"ROLE_NEW", (Object)((GeoServerRole)roleList.iterator().next()).getAuthority());
    }

    @Test
    public void testFill3() throws Exception {
        this.doTestFill3();
    }

    protected void doTestFill3() throws Exception {
        this.insertValues();
        this.initializeTester();
        tester.assertRenderedPage(NewUserPage.class);
        this.newFormTester();
        this.form.setValue("username", "testuser");
        this.form.setValue("password", "pwd");
        this.form.setValue("confirmPassword", "pwd");
        this.openCloseGroupPanel(NewUserPage.class);
        this.assignRole("ROLE_WMS");
        this.assertCalculatedRoles(new String[]{"ROLE_AUTHENTICATED", "ROLE_WMS"});
        this.form.submit("save");
        tester.assertErrorMessages((Serializable[])new String[0]);
        tester.assertRenderedPage(SecurityNamedServiceEditPage.class);
        GeoServerUser user = this.ugService.getUserByUsername("testuser");
        Assert.assertNotNull((Object)user);
        Assert.assertTrue((boolean)user.isEnabled());
        SortedSet groupList = this.ugService.getGroupsForUser(user);
        Assert.assertEquals((long)0L, (long)groupList.size());
        SortedSet roleList = this.gaService.getRolesForUser("testuser");
        Assert.assertEquals((long)1L, (long)roleList.size());
        Assert.assertTrue((boolean)roleList.contains(this.gaService.createRoleObject("ROLE_WMS")));
        user = (GeoServerUser)this.ugService.loadUserByUsername("testuser");
        Assert.assertEquals((long)2L, (long)user.getAuthorities().size());
        Assert.assertTrue((boolean)user.getAuthorities().contains(this.gaService.createRoleObject("ROLE_AUTHENTICATED")));
        Assert.assertTrue((boolean)user.getAuthorities().contains(this.gaService.createRoleObject("ROLE_WMS")));
    }

    @Test
    public void testFill2() throws Exception {
        this.doTestFill2();
    }

    protected void doTestFill2() throws Exception {
        this.insertValues();
        this.addAdditonalData();
        this.initializeTester();
        tester.assertRenderedPage(NewUserPage.class);
        this.newFormTester();
        this.form.setValue("username", "testuser");
        this.form.setValue("password", "pwd");
        this.form.setValue("confirmPassword", "pwd");
        this.openCloseGroupPanel(NewUserPage.class);
        this.assignGroup("group1");
        this.assertCalculatedRoles(new String[]{"ROLE_AUTHENTICATED", "ROLE_WFS", "ROLE_WMS"});
        this.form.submit("save");
        tester.assertErrorMessages((Serializable[])new String[0]);
        tester.assertRenderedPage(SecurityNamedServiceEditPage.class);
        GeoServerUser user = this.ugService.getUserByUsername("testuser");
        Assert.assertNotNull((Object)user);
        Assert.assertTrue((boolean)user.isEnabled());
        SortedSet groupList = this.ugService.getGroupsForUser(user);
        Assert.assertEquals((long)1L, (long)groupList.size());
        Assert.assertEquals((Object)"group1", (Object)((GeoServerUserGroup)groupList.iterator().next()).getGroupname());
        SortedSet roleList = this.gaService.getRolesForUser("testuser");
        Assert.assertEquals((long)0L, (long)roleList.size());
        user = (GeoServerUser)this.ugService.loadUserByUsername("testuser");
        Assert.assertEquals((long)3L, (long)user.getAuthorities().size());
        Assert.assertTrue((boolean)user.getAuthorities().contains(this.gaService.createRoleObject("ROLE_AUTHENTICATED")));
        Assert.assertTrue((boolean)user.getAuthorities().contains(this.gaService.createRoleObject("ROLE_WFS")));
        Assert.assertTrue((boolean)user.getAuthorities().contains(this.gaService.createRoleObject("ROLE_WMS")));
    }

    @Test
    public void testUserNameConflict() throws Exception {
        this.insertValues();
        this.initializeTester();
        tester.assertRenderedPage(NewUserPage.class);
        this.newFormTester();
        this.form.setValue("username", "user1");
        this.form.setValue("password", "pwd");
        this.form.setValue("confirmPassword", "pwd");
        this.form.submit("save");
        Assert.assertTrue((boolean)this.testErrorMessagesWithRegExp(".*user1.*"));
        tester.getMessages(400);
        tester.assertRenderedPage(NewUserPage.class);
    }

    @Test
    public void testInvalidWorkflow() throws Exception {
        this.activateROUGService();
        AbstractSecurityPage returnPage = this.initializeForUGServiceNamed(this.getROUserGroupServiceName());
        boolean fail = true;
        try {
            this.page = (AbstractUserPage)new NewUserPage(this.getROUserGroupServiceName()).setReturnPage((Page)returnPage);
            tester.startPage((Page)this.page);
        }
        catch (RuntimeException ex) {
            fail = false;
        }
        if (fail) {
            Assert.fail((String)"No runtime exception for read only UserGroupService");
        }
    }

    @Test
    public void testPasswordsDontMatch() throws Exception {
        super.doTestPasswordsDontMatch(NewUserPage.class);
    }
}

