/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web;

import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.extensions.markup.html.tabs.AbstractTab;
import org.apache.wicket.extensions.markup.html.tabs.TabbedPanel;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.StringResourceModel;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.web.SecurityNamedServicePage;
import org.geoserver.security.web.SecurityNamedServicePanelInfo;
import org.geoserver.security.web.SecurityNamedServiceTabbedPanel;
import org.geoserver.web.GeoServerApplication;

public class SecurityNamedServiceEditPage<T extends SecurityNamedServiceConfig>
extends SecurityNamedServicePage<T> {
    SecurityNamedServicePanelInfo panelInfo;

    public SecurityNamedServiceEditPage(IModel<T> config) {
        this.panelInfo = this.lookupPanelInfo(config);
        this.panel = this.createPanel("dummy", this.panelInfo, config);
        this.add(new Component[]{new Label("name", (Serializable)((Object)((SecurityNamedServiceConfig)config.getObject()).getName()))});
        this.add(new Component[]{new Label("title", (IModel)this.createTitleModel(this.panelInfo))});
        this.add(new Component[]{new Label("description", (IModel)this.createDescriptionModel(this.panelInfo))});
        if (SecurityNamedServiceTabbedPanel.class.isAssignableFrom(this.panelInfo.getComponentClass())) {
            this.add(new Component[]{new TabbedLayoutPanel("panel", config)});
        } else {
            this.add(new Component[]{new BasicLayoutPanel("panel", config)});
        }
    }

    void copyToClipBoard(String text) {
        StringSelection selection = new StringSelection(text);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(selection, selection);
    }

    SecurityNamedServicePanelInfo lookupPanelInfo(IModel<T> model) {
        SecurityNamedServiceConfig config = (SecurityNamedServiceConfig)model.getObject();
        Class<?> serviceClass = null;
        try {
            serviceClass = Class.forName(config.getClassName());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        ArrayList<SecurityNamedServicePanelInfo> panelInfos = new ArrayList<SecurityNamedServicePanelInfo>();
        for (SecurityNamedServicePanelInfo pageInfo : GeoServerApplication.get().getBeansOfType(SecurityNamedServicePanelInfo.class)) {
            if (!pageInfo.getServiceClass().isAssignableFrom(serviceClass)) continue;
            panelInfos.add(pageInfo);
        }
        if (panelInfos.isEmpty()) {
            throw new RuntimeException("Unable to find panel info for service config: " + config + ", service class: " + serviceClass);
        }
        if (panelInfos.size() > 1) {
            ArrayList l = new ArrayList(panelInfos);
            Iterator it = l.iterator();
            while (it.hasNext()) {
                SecurityNamedServicePanelInfo targetPanelInfo = (SecurityNamedServicePanelInfo)((Object)it.next());
                if (!targetPanelInfo.getServiceClass().equals(serviceClass)) {
                    it.remove();
                    continue;
                }
                if (targetPanelInfo.getServiceConfigClass().equals(config.getClass())) continue;
                it.remove();
            }
            if (l.size() == 1) {
                return (SecurityNamedServicePanelInfo)((Object)l.get(0));
            }
            throw new RuntimeException("Found multiple panel infos for service config: " + config + ", service class: " + serviceClass);
        }
        return (SecurityNamedServicePanelInfo)((Object)panelInfos.get(0));
    }

    class BasicLayoutPanel
    extends Panel {
        public BasicLayoutPanel(String id, IModel<T> config) {
            super(id, (IModel)new Model());
            this.add(new Component[]{new ContentPanel("panel", config)});
        }
    }

    class ContentPanel
    extends Panel {
        public ContentPanel(String id, IModel<T> config) {
            super(id, (IModel)new Model());
            Form form = new Form("form", (IModel)new CompoundPropertyModel(config));
            this.add(new Component[]{form});
            Component[] componentArray = new Component[1];
            SecurityNamedServiceEditPage.this.panel = SecurityNamedServiceEditPage.this.createPanel("panel", SecurityNamedServiceEditPage.this.panelInfo, config);
            componentArray[0] = SecurityNamedServiceEditPage.this.panel;
            form.add(componentArray);
            form.add(new Component[]{new SubmitLink("save", form){

                public void onSubmit() {
                    SecurityNamedServiceEditPage.this.handleSubmit(this.getForm());
                }
            }.setVisible(SecurityNamedServiceEditPage.this.getSecurityManager().checkAuthenticationForAdminRole())});
            form.add(new Component[]{new Link("cancel"){

                public void onClick() {
                    SecurityNamedServiceEditPage.this.doReturn();
                }
            }});
        }
    }

    class ErrorPanel
    extends Panel {
        public ErrorPanel(String id, final Exception error) {
            super(id, (IModel)new Model());
            this.add(new Component[]{new Label("message", (IModel)new PropertyModel((Object)error, "message"))});
            this.add(new Component[]{new TextArea("stackTrace", (IModel)new Model((Serializable)((Object)this.handleStackTrace(error))))});
            this.add(new Component[]{new AjaxLink("copy"){

                public void onClick(AjaxRequestTarget target) {
                    SecurityNamedServiceEditPage.this.copyToClipBoard(ErrorPanel.this.handleStackTrace(error));
                }
            }});
        }

        public String getLabelKey() {
            return "error";
        }

        String handleStackTrace(Exception error) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            PrintWriter writer = new PrintWriter(out);
            error.printStackTrace(writer);
            writer.flush();
            return new String(out.toByteArray());
        }
    }

    class TabbedLayoutPanel
    extends Panel {
        public TabbedLayoutPanel(String id, final IModel<T> config) {
            super(id, (IModel)new Model());
            ArrayList<AbstractTab> tabs = new ArrayList<AbstractTab>();
            tabs.add(new AbstractTab((IModel)new StringResourceModel("settings", null)){

                public Panel getPanel(String panelId) {
                    return new ContentPanel(panelId, config);
                }
            });
            tabs.addAll(((SecurityNamedServiceTabbedPanel)((Object)SecurityNamedServiceEditPage.this.panel)).createTabs(config));
            try {
                SecurityNamedServiceEditPage.this.panel.doLoad((SecurityNamedServiceConfig)config.getObject());
            }
            catch (Exception e) {
                tabs.add(new AbstractTab((IModel)new StringResourceModel("error", null)){

                    public Panel getPanel(String panelId) {
                        return new ErrorPanel(panelId, e);
                    }
                });
            }
            this.add(new Component[]{new TabbedPanel("panel", tabs)});
        }
    }
}

