/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.passwd;

import java.io.Serializable;
import org.apache.wicket.Page;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.security.password.MasterPasswordProviderConfig;
import org.geoserver.security.web.AbstractSecurityWicketTestSupport;
import org.geoserver.security.web.passwd.MasterPasswordChangePage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MasterPasswordChangePanelTest
extends AbstractSecurityWicketTestSupport {
    FormTester ft;

    @Override
    @Before
    public void setUp() throws Exception {
        MasterPasswordProviderConfig masterPasswordConfig = this.getSecurityManager().loadMasterPassswordProviderConfig(this.getSecurityManager().getMasterPasswordConfig().getProviderName());
        masterPasswordConfig.setLoginEnabled(true);
        this.getSecurityManager().saveMasterPasswordProviderConfig(masterPasswordConfig);
        this.login();
        tester.startPage((Page)new MasterPasswordChangePage());
        tester.assertRenderedPage(MasterPasswordChangePage.class);
        this.ft = tester.newFormTester("form");
    }

    @Test
    public void testRequiredFields() throws Exception {
        this.ft.submit();
        tester.assertErrorMessages((Serializable[])new String[]{"Field 'Current password' is required.", "Field 'New password' is required.", "Field 'Confirmation' is required."});
    }

    @Test
    public void testBadCurrentPassword() throws Exception {
        this.ft.setValue("currentPassword", "foo");
        this.ft.setValue("newPassword", "bar");
        this.ft.setValue("newPasswordConfirm", "bar");
        this.ft.submit("save");
        Assert.assertTrue((boolean)this.testErrorMessagesWithRegExp(".*Current master password invalid.*"));
    }

    @Test
    public void testPasswordViolatesPolicy() throws Exception {
        String mpw = this.getMasterPassword();
        System.out.println("testPasswordViolatesPolicy: " + mpw);
        this.ft.setValue("currentPassword", mpw);
        this.ft.setValue("newPassword", "bar");
        this.ft.setValue("newPasswordConfirm", "bar");
        this.ft.submit("save");
        Assert.assertTrue((boolean)this.testErrorMessagesWithRegExp(".*PasswordPolicyException.*"));
    }

    @Test
    public void testPasswordChange() throws Exception {
        String mpw = this.getMasterPassword();
        System.out.println("testPasswordChange: " + mpw);
        this.ft.setValue("currentPassword", mpw);
        this.ft.setValue("newPassword", "Foobar2012");
        this.ft.setValue("newPasswordConfirm", "Foobar2012");
        this.ft.submit("save");
        tester.assertNoErrorMessage();
        Assert.assertTrue((boolean)this.getSecurityManager().checkMasterPassword("Foobar2012"));
    }
}

