/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.user;

import org.apache.wicket.Page;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.security.web.AbstractSecurityWicketTestSupport;
import org.geoserver.security.web.group.NewGroupPage;
import org.geoserver.security.web.role.NewRolePage;
import org.geoserver.security.web.user.AbstractUserPage;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractUserPageTest
extends AbstractSecurityWicketTestSupport {
    protected AbstractUserPage page;
    protected FormTester form;

    protected abstract void initializeTester();

    @Test
    public void testReadOnlyRoleService() throws Exception {
        this.doInitialize();
        this.activateRORoleService();
        this.initializeTester();
        Assert.assertTrue((boolean)this.page.userGroupPalette.isEnabled());
    }

    protected void doInitialize() throws Exception {
        this.initializeForXML();
    }

    protected void doTestPasswordsDontMatch(Class<? extends Page> pageClass) throws Exception {
        this.doInitialize();
        this.initializeTester();
        this.newFormTester();
        this.form.setValue("username", "user");
        this.form.setValue("password", "pwd1");
        this.form.setValue("confirmPassword", "pwd2");
        this.form.submit("save");
        Assert.assertTrue((boolean)this.testErrorMessagesWithRegExp(".*[Pp]assword.*"));
        tester.assertRenderedPage(pageClass);
    }

    protected void newFormTester() {
        this.form = tester.newFormTester("form");
    }

    protected void addNewRole(String roleName) {
        this.form.submit("roles:addRole");
        tester.assertRenderedPage(NewRolePage.class);
        FormTester roleform = tester.newFormTester("form");
        roleform.setValue("name", "ROLE_NEW");
        roleform.submit("save");
        this.newFormTester();
    }

    protected void addNewGroup(String groupName) {
        this.form.submit("groups:addGroup");
        tester.assertRenderedPage(NewGroupPage.class);
        FormTester groupform = tester.newFormTester("form");
        groupform.setValue("groupname", groupName);
        groupform.submit("save");
        this.newFormTester();
    }

    protected void assignRole(String roleName) throws Exception {
        this.form.setValue("roles:palette:recorder", this.gaService.getRoleByName(roleName).getAuthority());
        this.form.submit();
        tester.executeAjaxEvent("form:roles:palette:recorder", "change");
        this.newFormTester();
        this.form.setValue("roles:palette:recorder", this.gaService.getRoleByName(roleName).getAuthority());
    }

    protected void assignGroup(String groupName) throws Exception {
        String theName = this.ugService.getGroupByGroupname(groupName).getGroupname();
        this.form.setValue("groups:palette:recorder", theName);
        this.form.submit();
        tester.executeAjaxEvent("form:groups:palette:recorder", "change");
        this.newFormTester();
        this.form.setValue("groups:palette:recorder", theName);
    }

    protected void openCloseRolePanel(Class<? extends Page> responseClass) {
        this.form.submit("roles:addRole");
        tester.assertRenderedPage(NewRolePage.class);
        tester.clickLink("form:cancel");
        tester.assertRenderedPage(responseClass);
        this.newFormTester();
    }

    protected void openCloseGroupPanel(Class<? extends Page> responseClass) {
        this.form.submit("groups:addGroup");
        tester.assertRenderedPage(NewGroupPage.class);
        tester.clickLink("form:cancel");
        tester.assertRenderedPage(responseClass);
        this.newFormTester();
    }

    protected void addUserProperty(String key, String value) {
        tester.executeAjaxEvent("form:properties:add", "click");
        this.form.setValue("properties:container:list:0:key", key);
        this.form.setValue("properties:container:list:0:value", value);
    }

    protected void assertCalculatedRoles(String[] roles) throws Exception {
        int i = 0;
        while (i < roles.length) {
            tester.assertModelValue("form:calculatedRolesContainer:calculatedRoles:" + i, (Object)this.gaService.getRoleByName(roles[i]));
            ++i;
        }
    }
}

