/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.user;

import java.io.Serializable;
import java.util.SortedSet;
import org.apache.wicket.Page;
import org.apache.wicket.extensions.markup.html.form.palette.component.Recorder;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.impl.GeoServerUser;
import org.geoserver.security.password.GeoServerPasswordEncoder;
import org.geoserver.security.web.AbstractSecurityPage;
import org.geoserver.security.web.user.AbstractUserPage;
import org.geoserver.security.web.user.AbstractUserPageTest;
import org.geoserver.security.web.user.EditUserPage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EditUserPageTest
extends AbstractUserPageTest {
    GeoServerUser current;

    @Before
    public void init() throws Exception {
        this.doInitialize();
        this.clearServices();
        this.deactivateRORoleService();
        this.deactivateROUGService();
    }

    @Test
    public void testFill() throws Exception {
        this.doTestFill();
    }

    protected void doTestFill() throws Exception {
        this.insertValues();
        this.addAdditonalData();
        this.current = this.ugService.getUserByUsername("user1");
        this.initializeTester();
        tester.assertRenderedPage(EditUserPage.class);
        Assert.assertFalse((boolean)tester.getComponentFromLastRenderedPage("form:username").isEnabled());
        tester.assertModelValue("form:username", (Object)"user1");
        GeoServerPasswordEncoder encoder = (GeoServerPasswordEncoder)GeoServerExtensions.bean((String)this.ugService.getPasswordEncoderName());
        String enc = (String)tester.getComponentFromLastRenderedPage("form:password").getDefaultModelObject();
        Assert.assertTrue((boolean)encoder.isPasswordValid(enc, "11111", null));
        enc = (String)tester.getComponentFromLastRenderedPage("form:confirmPassword").getDefaultModelObject();
        Assert.assertTrue((boolean)encoder.isPasswordValid(enc, "11111", null));
        tester.assertModelValue("form:enabled", (Object)Boolean.TRUE);
        this.newFormTester();
        this.form.setValue("enabled", false);
        Assert.assertTrue((boolean)this.page.userGroupPalette.isEnabled());
        tester.assertComponent("form:roles:palette:recorder", Recorder.class);
        tester.debugComponentTrees();
        this.addNewRole("ROLE_NEW");
        tester.assertRenderedPage(EditUserPage.class);
        this.assignRole("ROLE_NEW");
        this.openCloseRolePanel(EditUserPage.class);
        this.assertCalculatedRoles(new String[]{"ROLE_AUTHENTICATED", "ROLE_NEW", "ROLE_WFS", "ROLE_WMS"});
        this.addNewGroup("testgroup");
        this.assignGroup("testgroup");
        this.openCloseGroupPanel(EditUserPage.class);
        this.assertCalculatedRoles(new String[]{"ROLE_NEW"});
        this.form.submit("save");
        tester.assertErrorMessages((Serializable[])new String[0]);
        GeoServerUser user = this.ugService.getUserByUsername("user1");
        Assert.assertNotNull((Object)user);
        Assert.assertFalse((boolean)user.isEnabled());
        SortedSet groupList = this.ugService.getGroupsForUser(user);
        Assert.assertEquals((long)1L, (long)groupList.size());
        Assert.assertTrue((boolean)groupList.contains(this.ugService.getGroupByGroupname("testgroup")));
        SortedSet roleList = this.gaService.getRolesForUser("user1");
        Assert.assertEquals((long)1L, (long)roleList.size());
        Assert.assertTrue((boolean)roleList.contains(this.gaService.getRoleByName("ROLE_NEW")));
    }

    @Test
    public void testReadOnlyUserGroupService() throws Exception {
        this.initializeForXML();
        this.doTestReadOnlyUserGroupService();
    }

    protected void doTestReadOnlyUserGroupService() throws Exception {
        this.insertValues();
        this.activateROUGService();
        AbstractSecurityPage returnPage = this.initializeForUGServiceNamed(this.getROUserGroupServiceName());
        this.current = this.ugService.getUserByUsername("user1");
        this.page = (AbstractUserPage)new EditUserPage(this.getROUserGroupServiceName(), this.current).setReturnPage((Page)returnPage);
        tester.startPage((Page)this.page);
        tester.assertRenderedPage(EditUserPage.class);
        Assert.assertFalse((boolean)tester.getComponentFromLastRenderedPage("form:username").isEnabled());
        Assert.assertFalse((boolean)tester.getComponentFromLastRenderedPage("form:password").isEnabled());
        Assert.assertFalse((boolean)tester.getComponentFromLastRenderedPage("form:confirmPassword").isEnabled());
        Assert.assertFalse((boolean)tester.getComponentFromLastRenderedPage("form:enabled").isEnabled());
        Assert.assertTrue((boolean)tester.getComponentFromLastRenderedPage("form:roles").isEnabled());
        Assert.assertFalse((boolean)tester.getComponentFromLastRenderedPage("form:groups").isEnabled());
        Assert.assertFalse((boolean)tester.getComponentFromLastRenderedPage("form:properties").isEnabled());
        tester.assertVisible("form:save");
        this.newFormTester();
        this.assignRole(GeoServerRole.ADMIN_ROLE.getAuthority());
        this.form.submit("save");
        SortedSet roleList = this.gaService.getRolesForUser("user1");
        Assert.assertEquals((long)1L, (long)roleList.size());
        Assert.assertTrue((boolean)roleList.contains(this.gaService.getRoleByName(GeoServerRole.ADMIN_ROLE.getAuthority())));
    }

    @Override
    @Test
    public void testReadOnlyRoleService() throws Exception {
        this.doTestReadOnlyRoleService();
    }

    protected void doTestReadOnlyRoleService() throws Exception {
        this.insertValues();
        this.activateRORoleService();
        this.current = this.ugService.getUserByUsername("user1");
        this.initializeTester();
        tester.assertRenderedPage(EditUserPage.class);
        Assert.assertFalse((boolean)tester.getComponentFromLastRenderedPage("form:username").isEnabled());
        Assert.assertTrue((boolean)tester.getComponentFromLastRenderedPage("form:password").isEnabled());
        Assert.assertTrue((boolean)tester.getComponentFromLastRenderedPage("form:confirmPassword").isEnabled());
        Assert.assertTrue((boolean)tester.getComponentFromLastRenderedPage("form:enabled").isEnabled());
        Assert.assertFalse((boolean)tester.getComponentFromLastRenderedPage("form:roles").isEnabled());
        Assert.assertTrue((boolean)tester.getComponentFromLastRenderedPage("form:groups").isEnabled());
        Assert.assertTrue((boolean)tester.getComponentFromLastRenderedPage("form:properties").isEnabled());
        tester.assertVisible("form:save");
        this.newFormTester();
        this.form.setValue("enabled", Boolean.FALSE.booleanValue());
        this.form.submit("save");
        GeoServerUser user = this.ugService.getUserByUsername("user1");
        Assert.assertNotNull((Object)user);
        Assert.assertFalse((boolean)user.isEnabled());
    }

    @Test
    public void testAllServicesReadOnly() throws Exception {
        this.insertValues();
        this.activateROUGService();
        this.activateRORoleService();
        AbstractSecurityPage returnPage = this.initializeForUGServiceNamed(this.getROUserGroupServiceName());
        this.current = this.ugService.getUserByUsername("user1");
        this.page = (AbstractUserPage)new EditUserPage(this.getROUserGroupServiceName(), this.current).setReturnPage((Page)returnPage);
        tester.startPage((Page)this.page);
        tester.assertRenderedPage(EditUserPage.class);
        Assert.assertFalse((boolean)tester.getComponentFromLastRenderedPage("form:username").isEnabled());
        Assert.assertFalse((boolean)tester.getComponentFromLastRenderedPage("form:password").isEnabled());
        Assert.assertFalse((boolean)tester.getComponentFromLastRenderedPage("form:confirmPassword").isEnabled());
        Assert.assertFalse((boolean)tester.getComponentFromLastRenderedPage("form:enabled").isEnabled());
        Assert.assertFalse((boolean)tester.getComponentFromLastRenderedPage("form:roles").isEnabled());
        Assert.assertFalse((boolean)tester.getComponentFromLastRenderedPage("form:groups").isEnabled());
        Assert.assertFalse((boolean)tester.getComponentFromLastRenderedPage("form:properties").isEnabled());
        Assert.assertFalse((boolean)tester.getComponentFromLastRenderedPage("form:properties").isEnabled());
    }

    @Override
    protected void initializeTester() {
        AbstractSecurityPage returnPage = this.initializeForUGServiceNamed(this.getUserGroupServiceName());
        this.page = (AbstractUserPage)new EditUserPage(this.getUserGroupServiceName(), this.current).setReturnPage((Page)returnPage);
        tester.startPage((Page)this.page);
    }

    @Test
    public void testPasswordsDontMatch() throws Exception {
        this.insertValues();
        this.current = this.ugService.getUserByUsername("user1");
        super.doTestPasswordsDontMatch(EditUserPage.class);
    }
}

