/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web;

import org.apache.wicket.Page;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.config.SecurityManagerConfig;
import org.geoserver.security.web.AbstractSecurityWicketTestSupport;
import org.geoserver.security.web.SecuritySettingsPage;
import org.junit.Assert;
import org.junit.Test;

public class SecuritySettingsPageTest
extends AbstractSecurityWicketTestSupport {
    GeoServerSecurityManager manager;

    @Test
    public void testMangerConfigPanel() throws Exception {
        this.initializeForXML();
        this.createUserPasswordAuthProvider("default2", "default");
        this.activateRORoleService();
        this.manager = this.getSecurityManager();
        tester.startPage((Page)new SecuritySettingsPage());
        tester.assertRenderedPage(SecuritySettingsPage.class);
        SecurityManagerConfig config = this.manager.getSecurityConfig();
        tester.assertModelValue("form:roleServiceName", (Object)"default");
        tester.assertModelValue("form:encryption:encryptingUrlParams", (Object)config.isEncryptingUrlParams());
        tester.assertModelValue("form:encryption:configPasswordEncrypterName", (Object)this.getPBEPasswordEncoder().getName());
        FormTester form = tester.newFormTester("form");
        form.setValue("roleServiceName", this.getRORoleServiceName());
        form.setValue("encryption:encryptingUrlParams", false);
        form.setValue("encryption:configPasswordEncrypterName", this.getPlainTextPasswordEncoder().getName());
        form.submit("save");
        tester.assertNoErrorMessage();
        Assert.assertEquals((Object)false, (Object)this.manager.getSecurityConfig().isEncryptingUrlParams());
        Assert.assertEquals((Object)this.getPlainTextPasswordEncoder().getName(), (Object)this.manager.getSecurityConfig().getConfigPasswordEncrypterName());
        Assert.assertEquals((Object)this.getRORoleServiceName(), (Object)this.manager.getActiveRoleService().getName());
    }
}

